/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.texture;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.Short2LongMap;
import it.unimi.dsi.fastutil.shorts.Short2LongOpenHashMap;
import java.nio.LongBuffer;
import net.vulkanmod.vulkan.Vulkan;
import net.vulkanmod.vulkan.device.DeviceManager;
import org.apache.commons.lang3.Validate;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkSamplerCreateInfo;
import org.lwjgl.vulkan.VkSamplerReductionModeCreateInfo;

public abstract class SamplerManager {
    static final float MIP_BIAS = -0.5f;
    static final Short2LongMap SAMPLERS = new Short2LongOpenHashMap();
    public static final byte LINEAR_FILTERING_BIT = 1;
    public static final byte CLAMP_BIT = 2;
    public static final byte USE_MIPMAPS_BIT = 4;
    public static final byte MIPMAP_LINEAR_FILTERING_BIT = 8;
    public static final byte REDUCTION_MIN_BIT = 16;
    public static final byte REDUCTION_MAX_BIT = 32;

    public static long getTextureSampler(byte maxLod, byte flags) {
        short key = (short)(flags | maxLod << 8);
        long sampler = SAMPLERS.getOrDefault(key, 0L);
        if (sampler == 0L) {
            sampler = SamplerManager.createTextureSampler(maxLod, flags);
            SAMPLERS.put(key, sampler);
        }
        return sampler;
    }

    private static long createTextureSampler(byte maxLod, byte flags) {
        Validate.isTrue(((flags & 0x30) != 48 ? 1 : 0) != 0);
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkSamplerCreateInfo samplerInfo = VkSamplerCreateInfo.calloc((MemoryStack)stack);
            samplerInfo.sType(31);
            if ((flags & 1) != 0) {
                samplerInfo.magFilter(1);
                samplerInfo.minFilter(1);
            } else {
                samplerInfo.magFilter(0);
                samplerInfo.minFilter(0);
            }
            if ((flags & 2) != 0) {
                samplerInfo.addressModeU(2);
                samplerInfo.addressModeV(2);
                samplerInfo.addressModeW(2);
            } else {
                samplerInfo.addressModeU(0);
                samplerInfo.addressModeV(0);
                samplerInfo.addressModeW(0);
            }
            samplerInfo.anisotropyEnable(false);
            samplerInfo.borderColor(5);
            samplerInfo.unnormalizedCoordinates(false);
            samplerInfo.compareEnable(false);
            samplerInfo.compareOp(7);
            if ((flags & 4) == 0) {
                samplerInfo.mipmapMode(0);
                samplerInfo.maxLod(0.0f);
                samplerInfo.minLod(0.0f);
            } else {
                if ((flags & 8) != 0) {
                    samplerInfo.mipmapMode(1);
                } else {
                    samplerInfo.mipmapMode(0);
                }
                samplerInfo.maxLod((float)maxLod);
                samplerInfo.minLod(0.0f);
                samplerInfo.mipLodBias(-0.5f);
            }
            if ((flags & 0x30) != 0) {
                VkSamplerReductionModeCreateInfo reductionModeInfo = VkSamplerReductionModeCreateInfo.calloc((MemoryStack)stack);
                reductionModeInfo.sType$Default();
                reductionModeInfo.reductionMode((flags & 0x20) != 0 ? 2 : 1);
                samplerInfo.pNext(reductionModeInfo.address());
            }
            LongBuffer pTextureSampler = stack.mallocLong(1);
            if (VK10.vkCreateSampler((VkDevice)Vulkan.getVkDevice(), (VkSamplerCreateInfo)samplerInfo, null, (LongBuffer)pTextureSampler) != 0) {
                throw new RuntimeException("Failed to create texture sampler");
            }
            long l = pTextureSampler.get(0);
            return l;
        }
    }

    public static void cleanUp() {
        LongIterator longIterator = SAMPLERS.values().iterator();
        while (longIterator.hasNext()) {
            long id = (Long)longIterator.next();
            VK10.vkDestroySampler((VkDevice)DeviceManager.vkDevice, (long)id, null);
        }
    }
}

