/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.shader.layout;

import java.util.ArrayList;
import java.util.List;
import net.vulkanmod.vulkan.shader.descriptor.UBO;
import net.vulkanmod.vulkan.shader.layout.PushConstants;
import net.vulkanmod.vulkan.shader.layout.Uniform;

public abstract class AlignedStruct {
    protected List<Uniform> uniforms = new ArrayList<Uniform>();
    protected int size;

    protected AlignedStruct(List<Uniform.Info> infoList, int size) {
        this.size = size;
        if (infoList == null) {
            return;
        }
        for (Uniform.Info info : infoList) {
            Uniform uniform = Uniform.createField(info);
            this.uniforms.add(uniform);
        }
    }

    public void update(long ptr) {
        for (Uniform uniform : this.uniforms) {
            uniform.update(ptr);
        }
    }

    public List<Uniform> getUniforms() {
        return this.uniforms;
    }

    public int getSize() {
        return this.size;
    }

    public static class Builder {
        final List<Uniform.Info> uniforms = new ArrayList<Uniform.Info>();
        protected int currentOffset = 0;

        public void addUniformInfo(String type, String name, int count) {
            Uniform.Info info = Uniform.createUniformInfo(type, name, count);
            this.addUniformInfo(info);
        }

        public void addUniformInfo(String type, String name) {
            Uniform.Info info = Uniform.createUniformInfo(type, name);
            this.addUniformInfo(info);
        }

        public void addUniformInfo(Uniform.Info uniformInfo) {
            this.currentOffset = uniformInfo.computeAlignmentOffset(this.currentOffset);
            this.currentOffset += uniformInfo.size;
            this.uniforms.add(uniformInfo);
        }

        public UBO buildUBO(int binding, int stages) {
            return new UBO(binding, stages, this.currentOffset * 4, this.uniforms);
        }

        public PushConstants buildPushConstant() {
            if (this.uniforms.isEmpty()) {
                return null;
            }
            return new PushConstants(this.uniforms, this.currentOffset * 4);
        }
    }
}

