/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.shader.converter;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.vulkanmod.vulkan.shader.converter.CodeParser;
import net.vulkanmod.vulkan.shader.converter.InputOutputParser;
import net.vulkanmod.vulkan.shader.converter.UniformParser;
import net.vulkanmod.vulkan.shader.descriptor.ImageDescriptor;
import net.vulkanmod.vulkan.shader.descriptor.UBO;

public class GlslConverter {
    ShaderStage shaderStage;
    private State state;
    private UniformParser uniformParser;
    private InputOutputParser inOutParser;
    private String vshConverted;
    private String fshConverted;

    public void process(String vertShader, String fragShader) {
        this.uniformParser = new UniformParser(this);
        this.inOutParser = new InputOutputParser(this);
        StringBuilder vshOut = this.processShaderFile(ShaderStage.Vertex, vertShader);
        vshOut.insert(0, this.inOutParser.createInOutCode());
        StringBuilder fshOut = this.processShaderFile(ShaderStage.Fragment, fragShader);
        fshOut.insert(0, this.inOutParser.createInOutCode());
        String uniformBlock = this.uniformParser.createUniformsCode();
        vshOut.insert(0, uniformBlock);
        fshOut.insert(0, uniformBlock);
        String samplersVertCode = this.uniformParser.createSamplersCode(ShaderStage.Vertex);
        String samplersFragCode = this.uniformParser.createSamplersCode(ShaderStage.Fragment);
        vshOut.insert(0, samplersVertCode);
        fshOut.insert(0, samplersFragCode);
        vshOut.insert(0, "#version 450\n\n");
        fshOut.insert(0, "#define sample sample1\n");
        fshOut.insert(0, "#version 450\n\n");
        this.vshConverted = vshOut.toString();
        this.fshConverted = fshOut.toString();
    }

    private StringBuilder processShaderFile(ShaderStage stage, String shader) {
        this.setShaderStage(stage);
        String[] lines = shader.split("\n");
        StringBuilder out = new StringBuilder();
        Iterator iterator = Arrays.stream(lines).iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            int semicolons = this.charOccurences(line, ';');
            if (semicolons > 1) {
                String[] lines2 = line.splitWithDelimiters(";", 0);
                int matchingFor = 0;
                int i = 0;
                while (i < lines2.length) {
                    String parsedLine;
                    StringBuilder line2 = new StringBuilder(lines2[i]);
                    ++i;
                    matchingFor += this.charOccurences(line2.toString(), '(');
                    matchingFor -= this.charOccurences(line2.toString(), ')');
                    while (matchingFor > 0) {
                        String next = lines2[i];
                        ++i;
                        matchingFor += this.charOccurences(next, '(');
                        matchingFor -= this.charOccurences(next, ')');
                        line2.append(next);
                    }
                    if (i < lines2.length) {
                        line2.append(lines2[i]);
                        ++i;
                    }
                    if (matchingFor != 0 || (parsedLine = this.parseLine(line2.toString())) == null) continue;
                    out.append(parsedLine);
                    out.append("\n");
                }
                continue;
            }
            String parsedLine = this.parseLine(line);
            if (parsedLine == null) continue;
            out.append(parsedLine);
            out.append("\n");
        }
        return out;
    }

    private int charOccurences(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    private String parseLine(String line) {
        String token;
        StringTokenizer tokenizer = new StringTokenizer(line);
        if (!tokenizer.hasMoreTokens()) {
            return "\n";
        }
        switch (token = tokenizer.nextToken()) {
            case "uniform": {
                this.state = State.MATCHING_UNIFORM;
                break;
            }
            case "in": 
            case "out": {
                this.state = State.MATCHING_IN_OUT;
                break;
            }
            case "#version": {
                return null;
            }
            case "#moj_import": {
                if (tokenizer.countTokens() != 1) {
                    throw new IllegalArgumentException("Token count != 1");
                }
                return String.format("#include %s", tokenizer.nextToken());
            }
            default: {
                return CodeParser.parseCodeLine(line);
            }
        }
        if (tokenizer.countTokens() < 2) {
            throw new IllegalArgumentException("Less than 3 tokens present");
        }
        this.feedToken(token);
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            this.feedToken(token);
        }
        return null;
    }

    private void feedToken(String token) {
        switch (this.state.ordinal()) {
            case 0: {
                this.uniformParser.parseToken(token);
                break;
            }
            case 1: {
                this.inOutParser.parseToken(token);
            }
        }
    }

    private void setShaderStage(ShaderStage shaderStage) {
        this.shaderStage = shaderStage;
        this.uniformParser.setCurrentUniforms(this.shaderStage);
        this.inOutParser.setShaderStage(this.shaderStage);
    }

    public UBO createUBO() {
        return this.uniformParser.createUBO();
    }

    public List<ImageDescriptor> getSamplerList() {
        return this.uniformParser.getSamplers();
    }

    public String getVshConverted() {
        return this.vshConverted;
    }

    public String getFshConverted() {
        return this.fshConverted;
    }

    static enum ShaderStage {
        Vertex,
        Fragment;

    }

    static enum State {
        MATCHING_UNIFORM,
        MATCHING_IN_OUT;

    }
}

