/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk.build.task;

import net.minecraft.class_243;
import net.vulkanmod.render.chunk.RenderSection;
import net.vulkanmod.render.chunk.WorldRenderer;
import net.vulkanmod.render.chunk.build.UploadBuffer;
import net.vulkanmod.render.chunk.build.task.ChunkTask;
import net.vulkanmod.render.chunk.build.task.CompileResult;
import net.vulkanmod.render.chunk.build.task.CompiledSection;
import net.vulkanmod.render.chunk.build.thread.BuilderResources;
import net.vulkanmod.render.chunk.build.thread.ThreadBuilderPack;
import net.vulkanmod.render.vertex.QuadSorter;
import net.vulkanmod.render.vertex.TerrainBuilder;
import net.vulkanmod.render.vertex.TerrainRenderType;

public class SortTransparencyTask
extends ChunkTask {
    public SortTransparencyTask(RenderSection renderSection) {
        super(renderSection);
    }

    @Override
    public String name() {
        return "rend_chk_sort";
    }

    @Override
    public ChunkTask.Result runTask(BuilderResources context) {
        ThreadBuilderPack builderPack = context.builderPack;
        if (this.cancelled.get()) {
            return ChunkTask.Result.CANCELLED;
        }
        class_243 vec3 = WorldRenderer.getCameraPos();
        float x = (float)vec3.field_1352;
        float y = (float)vec3.field_1351;
        float z = (float)vec3.field_1350;
        CompiledSection compiledSection = this.section.getCompiledSection();
        QuadSorter.SortState transparencyState = compiledSection.transparencyState;
        TerrainBuilder bufferBuilder = builderPack.builder(TerrainRenderType.TRANSLUCENT);
        bufferBuilder.begin();
        bufferBuilder.restoreSortState(transparencyState);
        bufferBuilder.setupQuadSorting(x - (float)this.section.xOffset(), y - (float)this.section.yOffset(), z - (float)this.section.zOffset());
        TerrainBuilder.DrawState drawState = bufferBuilder.endDrawing();
        CompileResult compileResult = new CompileResult(this.section, false);
        UploadBuffer uploadBuffer = new UploadBuffer(bufferBuilder, drawState);
        compileResult.renderedLayers.put(TerrainRenderType.TRANSLUCENT, uploadBuffer);
        bufferBuilder.reset();
        if (this.cancelled.get()) {
            return ChunkTask.Result.CANCELLED;
        }
        taskDispatcher.scheduleSectionUpdate(compileResult);
        return ChunkTask.Result.SUCCESSFUL;
    }
}

