/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk.build.frapi.render;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.GlintMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.minecraft.class_10444;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7837;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.vulkanmod.mixin.render.frapi.ItemRendererAccessor;
import net.vulkanmod.render.chunk.build.frapi.helper.ColorHelper;
import net.vulkanmod.render.chunk.build.frapi.material.RenderMaterialImpl;
import net.vulkanmod.render.chunk.build.frapi.mesh.EncodingFormat;
import net.vulkanmod.render.chunk.build.frapi.mesh.MutableQuadViewImpl;
import net.vulkanmod.render.chunk.build.frapi.render.AbstractBlockRenderContext;
import net.vulkanmod.render.chunk.build.frapi.render.AbstractRenderContext;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ItemRenderContext
extends AbstractRenderContext {
    private static final long ITEM_RANDOM_SEED = 42L;
    private static final int GLINT_COUNT = class_10444.class_10445.values().length;
    private final class_5819 random = class_5819.method_43047();
    private final Supplier<class_5819> randomSupplier = () -> {
        this.random.method_43052(42L);
        return this.random;
    };
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            ItemRenderContext.this.bufferQuad(this);
        }

        @Override
        public void emitItemQuads(QuadEmitter emitter, class_1087 model, class_2680 state, Supplier<class_5819> randomSupplier) {
            ItemRenderContext.this.emitItemQuads(model, state, randomSupplier);
        }
    };
    private class_811 transformMode;
    private class_4587 matrixStack;
    private class_4597 vertexConsumerProvider;
    private int lightmap;
    private int[] tints;
    private class_1921 defaultLayer;
    private class_10444.class_10445 defaultGlint;
    private class_4587.class_4665 specialGlintEntry;
    private final class_4588[] vertexConsumerCache = new class_4588[3 * GLINT_COUNT];

    @Override
    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public void renderModel(class_811 transformMode, class_4587 matrixStack, class_4597 bufferSource, int lightmap, int overlay, int[] tints, class_1087 model, class_1921 renderType, class_10444.class_10445 foilType) {
        this.transformMode = transformMode;
        this.matrixStack = matrixStack;
        this.vertexConsumerProvider = bufferSource;
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.tints = tints;
        this.defaultLayer = renderType;
        this.defaultGlint = foilType;
        this.matrix = matrixStack.method_23760().method_23761();
        this.normalMatrix = matrixStack.method_23760().method_23762();
        model.emitItemQuads(this.getEmitter(), this.randomSupplier);
        this.matrixStack = null;
        this.vertexConsumerProvider = null;
        this.tints = null;
        this.specialGlintEntry = null;
        Arrays.fill(this.vertexConsumerCache, null);
    }

    public void emitItemQuads(class_1087 model, @Nullable class_2680 state, Supplier<class_5819> randomSupplier) {
        for (int i = 0; i <= 6; ++i) {
            class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
            List quads = model.method_4707(state, cullFace, randomSupplier.get());
            int count = quads.size();
            for (int j = 0; j < count; ++j) {
                class_777 q = (class_777)quads.get(j);
                this.editorQuad.fromVanilla(q, AbstractBlockRenderContext.STANDARD_MATERIAL, cullFace);
                this.bufferQuad(this.editorQuad);
            }
        }
    }

    @Override
    protected void bufferQuad(MutableQuadViewImpl quad) {
        RenderMaterialImpl mat = quad.material();
        boolean emissive = mat.emissive();
        class_4588 vertexConsumer = this.getVertexConsumer(mat.blendMode(), mat.glintMode());
        this.tintQuad(quad);
        this.shadeQuad(quad, emissive);
        this.bufferQuad(quad, vertexConsumer);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        int tintIndex = quad.tintIndex();
        if (tintIndex != -1 && tintIndex < this.tints.length) {
            int tint = this.tints[tintIndex];
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(tint, quad.color(i)));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int lightmap = this.lightmap;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), lightmap));
            }
        }
    }

    private class_4588 getVertexConsumer(BlendMode blendMode, GlintMode glintMode) {
        class_1921 layer = blendMode == BlendMode.DEFAULT ? this.defaultLayer : (blendMode == BlendMode.TRANSLUCENT ? class_4722.method_29382() : class_4722.method_24074());
        class_10444.class_10445 glint = glintMode == GlintMode.DEFAULT ? this.defaultGlint : glintMode.glint;
        int cacheIndex = layer == class_4722.method_29382() ? 0 : (layer == class_4722.method_24074() ? GLINT_COUNT : 2 * GLINT_COUNT);
        class_4588 vertexConsumer = this.vertexConsumerCache[cacheIndex += glint.ordinal()];
        if (vertexConsumer == null) {
            this.vertexConsumerCache[cacheIndex] = vertexConsumer = this.createVertexConsumer(layer, glint);
        }
        return vertexConsumer;
    }

    private class_4588 createVertexConsumer(class_1921 layer, class_10444.class_10445 glint) {
        if (glint == class_10444.class_10445.field_55343) {
            if (this.specialGlintEntry == null) {
                this.specialGlintEntry = this.matrixStack.method_23760().method_56822();
                if (this.transformMode == class_811.field_4317) {
                    class_7837.method_46414((Matrix4f)this.specialGlintEntry.method_23761(), (float)0.5f);
                } else if (this.transformMode.method_29998()) {
                    class_7837.method_46414((Matrix4f)this.specialGlintEntry.method_23761(), (float)0.75f);
                }
            }
            return ItemRendererAccessor.getCompassFoilBuffer(this.vertexConsumerProvider, layer, this.specialGlintEntry);
        }
        return class_918.method_23181((class_4597)this.vertexConsumerProvider, (class_1921)layer, (boolean)true, (glint != class_10444.class_10445.field_55341 ? 1 : 0) != 0);
    }
}

