/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk.build.biome;

import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2826;
import net.minecraft.class_3532;
import net.minecraft.class_4540;
import net.minecraft.class_7924;
import org.joml.Vector3f;

public class BiomeData {
    private static final int ZOOM_LENGTH = 4;
    private static final int BIOMES_PER_SECTION = 64;
    private static final int SIZE = 1728;
    class_1959[] biomes = new class_1959[1728];
    private final long biomeZoomSeed;
    int secX;
    int secY;
    int secZ;
    Vector3f[] offsets = new Vector3f[1728];

    public BiomeData(long biomeZoomSeed, int secX, int secY, int secZ) {
        this.biomeZoomSeed = biomeZoomSeed;
        this.secX = secX;
        this.secY = secY;
        this.secZ = secZ;
    }

    public void getBiomeData(class_1937 level, class_2826 chunkSection, int secX, int secY, int secZ) {
        class_1959 defaultValue = (class_1959)level.method_30349().method_30530(class_7924.field_41236).method_46747(class_1972.field_9451).comp_349();
        int baseIdx = BiomeData.getRelativeSectionIdx(secX, secY, secZ);
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    int relIdx = BiomeData.getRelativeIdx(x, y, z);
                    int idx = baseIdx + relIdx;
                    this.biomes[idx] = chunkSection != null ? (class_1959)chunkSection.method_38293(x, y, z).comp_349() : defaultValue;
                }
            }
        }
    }

    public class_1959 getBiome(int blockX, int blockY, int blockZ) {
        int x = blockX - 2;
        int y = blockY - 2;
        int z = blockZ - 2;
        int zoomX = x >> 2;
        int zoomY = y >> 2;
        int zoomZ = z >> 2;
        float fracZoomX = (float)(x & 3) * 0.25f;
        float fracZoomY = (float)(y & 3) * 0.25f;
        float fracZoomZ = (float)(z & 3) * 0.25f;
        int closestCellIdx = 0;
        double closestDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 8; ++i) {
            boolean dirX = (i & 4) != 0;
            boolean dirY = (i & 2) != 0;
            boolean dirZ = (i & 1) != 0;
            int cellX = dirX ? zoomX + 1 : zoomX;
            int cellY = dirY ? zoomY + 1 : zoomY;
            int cellZ = dirZ ? zoomZ + 1 : zoomZ;
            float fCellX = dirX ? fracZoomX - 1.0f : fracZoomX;
            float fCellY = dirY ? fracZoomY - 1.0f : fracZoomY;
            float fCellZ = dirZ ? fracZoomZ - 1.0f : fracZoomZ;
            int baseSectionIdx = this.getSectionIdx(cellX >> 2, cellY >> 2, cellZ >> 2);
            int cellIdx = baseSectionIdx + BiomeData.getRelativeIdx(cellX & 3, cellY & 3, cellZ & 3);
            Vector3f offset = this.getOffset(baseSectionIdx, cellX, cellY, cellZ);
            float distance = class_3532.method_27285((float)(fCellX + offset.x())) + class_3532.method_27285((float)(fCellY + offset.y())) + class_3532.method_27285((float)(fCellZ + offset.z()));
            if (!(closestDistance > (double)distance)) continue;
            closestCellIdx = cellIdx;
            closestDistance = distance;
        }
        return this.biomes[closestCellIdx];
    }

    private int getSectionIdx(int secX, int secY, int secZ) {
        return BiomeData.getRelativeSectionIdx(secX - this.secX, secY - this.secY, secZ - this.secZ);
    }

    private Vector3f getOffset(int baseIndex, int cellX, int cellY, int cellZ) {
        int relCellX = cellX & 3;
        int relCellY = cellY & 3;
        int relCellZ = cellZ & 3;
        int idx = baseIndex + BiomeData.getRelativeIdx(relCellX, relCellY, relCellZ);
        if (this.offsets[idx] == null) {
            this.offsets[idx] = BiomeData.computeCellOffset(this.biomeZoomSeed, cellX, cellY, cellZ);
        }
        return this.offsets[idx];
    }

    private static Vector3f computeCellOffset(long l, int cellX, int cellY, int cellZ) {
        long seed = class_4540.method_22372((long)l, (long)cellX);
        seed = class_4540.method_22372((long)seed, (long)cellY);
        seed = class_4540.method_22372((long)seed, (long)cellZ);
        seed = class_4540.method_22372((long)seed, (long)cellX);
        seed = class_4540.method_22372((long)seed, (long)cellY);
        seed = class_4540.method_22372((long)seed, (long)cellZ);
        float xOffset = BiomeData.getFiddle(seed);
        seed = class_4540.method_22372((long)seed, (long)l);
        float yOffset = BiomeData.getFiddle(seed);
        seed = class_4540.method_22372((long)seed, (long)l);
        float zOffset = BiomeData.getFiddle(seed);
        return new Vector3f(xOffset, yOffset, zOffset);
    }

    private static float getFiddle(long l) {
        float d = (float)Math.floorMod(l >> 24, 1024) * 9.765625E-4f;
        return (d - 0.5f) * 0.9f;
    }

    private static int getRelativeSectionIdx(int x, int y, int z) {
        return (x * 3 * 3 + y * 3 + z) * 64;
    }

    private static int getRelativeIdx(int x, int y, int z) {
        return x * 4 * 4 + y * 4 + z;
    }
}

