/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.mixin.texture.update;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1011;
import net.minecraft.class_10209;
import net.minecraft.class_1043;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_6367;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.vulkanmod.gl.GlTexture;
import net.vulkanmod.mixin.texture.image.NativeImageAccessor;
import net.vulkanmod.render.texture.ImageUploadHelper;
import net.vulkanmod.vulkan.queue.CommandPool;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_765.class})
public class MLightTexture {
    @Shadow
    @Final
    private class_310 field_4137;
    @Shadow
    @Final
    private class_757 field_4134;
    @Shadow
    @Final
    private class_6367 field_53101;
    @Shadow
    private boolean field_4135;
    @Shadow
    private float field_21528;
    private class_1043 lightTexture;
    private class_1011 lightPixels;
    private Vector3f[] tempVecs;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(class_757 gameRenderer, class_310 minecraft, CallbackInfo ci) {
        this.initLightMap();
        this.tempVecs = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f()};
    }

    private void initLightMap() {
        this.lightTexture = new class_1043(16, 16, false);
        this.lightPixels = this.lightTexture.method_4525();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.lightPixels.method_61941(j, i, -1);
            }
        }
        this.lightTexture.method_4524();
    }

    @Overwrite
    public void method_3316() {
        RenderSystem.setShaderTexture((int)2, (int)this.lightTexture.method_4624());
    }

    @Inject(method={"updateLightTexture"}, at={@At(value="HEAD")}, cancellable=true)
    public void updateLightTexture(float partialTicks, CallbackInfo ci) {
        if (this.field_4135) {
            this.field_4135 = false;
            class_3695 profilerFiller = class_10209.method_64146();
            profilerFiller.method_15396("lightTex");
            class_638 clientLevel = this.field_4137.field_1687;
            if (clientLevel != null) {
                float skyDarken = clientLevel.method_23783(1.0f);
                float skyFlashTime = clientLevel.method_23789() > 0 ? 1.0f : skyDarken * 0.95f + 0.05f;
                float darknessEffectScale = ((Double)this.field_4137.field_1690.method_42472().method_41753()).floatValue();
                float darknessGamma = this.getDarknessGamma(partialTicks) * darknessEffectScale;
                float darknessScale = this.calculateDarknessScale((class_1309)this.field_4137.field_1724, darknessGamma, partialTicks) * darknessEffectScale;
                float waterVision = this.field_4137.field_1724.method_3140();
                float nightVisionFactor = this.field_4137.field_1724.method_6059(class_1294.field_5925) ? class_757.method_3174((class_1309)this.field_4137.field_1724, (float)partialTicks) : (waterVision > 0.0f && this.field_4137.field_1724.method_6059(class_1294.field_5927) ? waterVision : 0.0f);
                skyDarken = MLightTexture.lerp(skyDarken, 1.0f, 0.35f);
                Vector3f skyLightColor = this.tempVecs[0].set(skyDarken, skyDarken, 1.0f);
                float redFlicker = this.field_21528 + 1.5f;
                Vector3f lightColor = this.tempVecs[1];
                float gamma = ((Double)this.field_4137.field_1690.method_42473().method_41753()).floatValue();
                float darkenWorldAmount = this.field_4134.method_3195(partialTicks);
                boolean forceBrightLightmap = clientLevel.method_28103().method_28114();
                float ambientLight = clientLevel.method_8597().comp_656();
                long ptr = ((NativeImageAccessor)this.lightPixels).getPixels();
                int width = this.lightPixels.method_4307();
                Vector3f tVec3f = this.tempVecs[2];
                for (int y = 0; y < 16; ++y) {
                    float brY = MLightTexture.getBrightness(ambientLight, y) * skyFlashTime;
                    for (int x = 0; x < 16; ++x) {
                        float maxComponent;
                        float brX = MLightTexture.getBrightness(ambientLight, x) * redFlicker;
                        float t = brX * ((brX * 0.6f + 0.4f) * 0.6f + 0.4f);
                        float u = brX * (brX * brX * 0.6f + 0.4f);
                        lightColor.set(brX, t, u);
                        if (forceBrightLightmap) {
                            lightColor.lerp((Vector3fc)tVec3f.set(0.99f, 1.12f, 1.0f), 0.25f);
                            MLightTexture.clampColor(lightColor);
                        } else {
                            tVec3f.set((Vector3fc)skyLightColor).mul(brY);
                            lightColor.add((Vector3fc)tVec3f);
                            tVec3f.set(0.75f, 0.75f, 0.75f);
                            lightColor.lerp((Vector3fc)tVec3f, 0.04f);
                            if (darkenWorldAmount > 0.0f) {
                                tVec3f.set((Vector3fc)lightColor).mul(0.7f, 0.6f, 0.6f);
                                lightColor.lerp((Vector3fc)tVec3f, darkenWorldAmount);
                            }
                        }
                        if (nightVisionFactor > 0.0f && (maxComponent = Math.max(lightColor.x(), Math.max(lightColor.y(), lightColor.z()))) < 1.0f) {
                            float brightColor = 1.0f / maxComponent;
                            tVec3f.set((Vector3fc)lightColor).mul(brightColor);
                            lightColor.lerp((Vector3fc)tVec3f, nightVisionFactor);
                        }
                        if (!forceBrightLightmap) {
                            lightColor.add(-darknessScale, -darknessScale, -darknessScale);
                            MLightTexture.clampColor(lightColor);
                        }
                        tVec3f.set(this.notGamma(lightColor.x), this.notGamma(lightColor.y), this.notGamma(lightColor.z));
                        lightColor.lerp((Vector3fc)tVec3f, Math.max(0.0f, gamma - darknessGamma));
                        lightColor.lerp((Vector3fc)tVec3f.set(0.75f, 0.75f, 0.75f), 0.04f);
                        MLightTexture.clampColor(lightColor);
                        lightColor.mul(255.0f);
                        int r = (int)lightColor.x();
                        int g = (int)lightColor.y();
                        int b = (int)lightColor.z();
                        MemoryUtil.memPutInt((long)(ptr + ((long)y * (long)width + (long)x) * 4L), (int)(0xFF000000 | b << 16 | g << 8 | r));
                    }
                }
                CommandPool.CommandBuffer commandBuffer = ImageUploadHelper.INSTANCE.getOrStartCommandBuffer();
                this.lightTexture.method_4524();
                try (MemoryStack stack = MemoryStack.stackPush();){
                    GlTexture.getTexture(this.lightTexture.method_4624()).getVulkanImage().readOnlyLayout(stack, commandBuffer.getHandle());
                }
                profilerFiller.method_15407();
            }
        }
        ci.cancel();
    }

    @Unique
    private float getDarknessGamma(float f) {
        class_1293 mobEffectInstance = this.field_4137.field_1724.method_6112(class_1294.field_38092);
        return mobEffectInstance != null ? mobEffectInstance.method_55653((class_1309)this.field_4137.field_1724, f) : 0.0f;
    }

    @Unique
    private float calculateDarknessScale(class_1309 livingEntity, float f, float g) {
        float h = 0.45f * f;
        return Math.max(0.0f, class_3532.method_15362((float)(((float)livingEntity.field_6012 - g) * (float)Math.PI * 0.025f)) * h);
    }

    @Unique
    private static float lerp(float a, float x, float t) {
        return (x - a) * t + a;
    }

    @Unique
    private static void clampColor(Vector3f vector3f) {
        vector3f.set(class_3532.method_15363((float)vector3f.x, (float)0.0f, (float)1.0f), class_3532.method_15363((float)vector3f.y, (float)0.0f, (float)1.0f), class_3532.method_15363((float)vector3f.z, (float)0.0f, (float)1.0f));
    }

    @Unique
    private float notGamma(float f) {
        float g = 1.0f - f;
        g *= g;
        return 1.0f - g * g;
    }

    @Unique
    private static float getBrightness(float ambientLight, int i) {
        float f = (float)i / 15.0f;
        float g = f / (4.0f - 3.0f * f);
        return class_3532.method_16439((float)ambientLight, (float)g, (float)1.0f);
    }
}

