/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.mixin.render.shader;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_10141;
import net.minecraft.class_10151;
import net.minecraft.class_10156;
import net.minecraft.class_10157;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4239;
import net.minecraft.class_5912;
import net.minecraft.class_5913;
import net.minecraft.class_5944;
import net.minecraft.class_7654;
import net.minecraft.class_9962;
import net.vulkanmod.interfaces.shader.PipelineConfig;
import net.vulkanmod.interfaces.shader.ShaderMixed;
import net.vulkanmod.render.shader.ShaderLoadUtil;
import net.vulkanmod.vulkan.shader.GraphicsPipeline;
import net.vulkanmod.vulkan.shader.Pipeline;
import net.vulkanmod.vulkan.shader.SPIRVUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_10151.class})
public abstract class ShaderManagerM {
    @Shadow
    @Final
    private static class_7654 field_53938;
    @Shadow
    private class_10151.class_10170 field_54020;
    @Shadow
    @Final
    private static Logger field_53937;
    @Shadow
    @Final
    private static class_7654 field_53939;

    @Overwrite
    public void method_62944(class_5912 resourceProvider, class_10156 ... shaderPrograms) throws IOException {
        for (class_10156 shaderProgram : shaderPrograms) {
            class_2960 location = field_53938.method_45112(shaderProgram.comp_3113());
            class_3298 resource = resourceProvider.getResourceOrThrow(location);
            BufferedReader reader = resource.method_43039();
            String locationPath = location.method_12832();
            String configName = locationPath.split("/")[2];
            configName = configName.substring(0, configName.length() - 5);
            try {
                JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                class_10157 shaderProgramConfig = (class_10157)class_10157.field_53949.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonSyntaxException::new);
                PipelineConfig.of(shaderProgramConfig).setName(configName);
                Pipeline.Builder builder = new Pipeline.Builder(shaderProgram.comp_3114());
                JsonObject config = ShaderLoadUtil.getJsonConfig("core", configName);
                builder.parseBindings(config);
                ShaderLoadUtil.loadShader(builder, configName, shaderProgramConfig.comp_3116().method_12832(), SPIRVUtils.ShaderKind.VERTEX_SHADER);
                ShaderLoadUtil.loadShader(builder, configName, shaderProgramConfig.comp_3117().method_12832(), SPIRVUtils.ShaderKind.FRAGMENT_SHADER);
                GraphicsPipeline pipeline = builder.createGraphicsPipeline();
                class_5944 compiledShaderProgram = ShaderManagerM.createProgram(pipeline);
                this.field_54020.field_54023.put(shaderProgram, Optional.of(compiledShaderProgram));
            }
            finally {
                ((Reader)reader).close();
            }
        }
    }

    @Overwrite
    public class_10151.class_10153 method_62942(class_3300 resourceManager, class_3695 profilerFiller) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        Predicate<class_2960> filter = location -> !location.method_12836().equals("vulkanmod") && (ShaderManagerM.isProgram(location) || ShaderManagerM.isShader(location));
        Map map = resourceManager.method_14488("shaders", filter);
        for (Map.Entry entry : map.entrySet()) {
            class_2960 resourceLocation = (class_2960)entry.getKey();
            class_10141.class_282 type = class_10141.class_282.method_62884((class_2960)resourceLocation);
            if (type != null) {
                ShaderManagerM.loadShader(resourceLocation, (class_3298)entry.getValue(), type, map, (ImmutableMap.Builder<class_10151.class_10155, String>)builder2);
                continue;
            }
            if (!ShaderManagerM.isProgram(resourceLocation)) continue;
            ShaderManagerM.loadProgram(resourceLocation, (class_3298)entry.getValue(), (ImmutableMap.Builder<class_2960, class_10157>)builder);
        }
        ImmutableMap.Builder builder3 = ImmutableMap.builder();
        for (Map.Entry entry2 : field_53939.method_45113(resourceManager).entrySet()) {
            ShaderManagerM.loadPostChain((class_2960)entry2.getKey(), (class_3298)entry2.getValue(), (ImmutableMap.Builder<class_2960, class_9962>)builder3);
        }
        return new class_10151.class_10153((Map)builder.build(), (Map)builder2.build(), (Map)builder3.build());
    }

    private static class_5913 createPreprocessor(final Map<class_2960, class_3298> map, class_2960 resourceLocation) {
        final class_2960 resourceLocation2 = resourceLocation.method_45134(class_4239::method_34675);
        return new class_5913(){
            private final Set<class_2960> importedLocations = new ObjectArraySet();

            public String method_34233(boolean bl, String string) {
                class_2960 resourceLocation;
                try {
                    resourceLocation = bl ? resourceLocation2.method_45134(string2 -> class_4239.method_34676((String)(string2 + string))) : class_2960.method_60654((String)string).method_45138("shaders/include/");
                }
                catch (class_151 var8) {
                    field_53937.error("Malformed GLSL import {}: {}", (Object)string, (Object)var8.getMessage());
                    return "#error " + var8.getMessage();
                }
                if (!this.importedLocations.add(resourceLocation)) {
                    return null;
                }
                try {
                    String var5;
                    try (BufferedReader reader = ((class_3298)map.get(resourceLocation)).method_43039();){
                        var5 = IOUtils.toString((Reader)reader);
                    }
                    return var5;
                }
                catch (IOException var10) {
                    field_53937.error("Could not open GLSL import {}: {}", (Object)resourceLocation, (Object)var10.getMessage());
                    return "#error " + var10.getMessage();
                }
            }
        };
    }

    private static void loadProgram(class_2960 resourceLocation, class_3298 resource, ImmutableMap.Builder<class_2960, class_10157> builder) {
        class_2960 resourceLocation2 = field_53938.method_45115(resourceLocation);
        try (BufferedReader reader = resource.method_43039();){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            class_10157 shaderProgramConfig = (class_10157)class_10157.field_53949.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonSyntaxException::new);
            String configPath = resourceLocation.method_12832();
            String configName = configPath.split("/")[2];
            configName = configName.substring(0, configName.length() - 5);
            PipelineConfig.of(shaderProgramConfig).setName(configName);
            builder.put((Object)resourceLocation2, (Object)shaderProgramConfig);
        }
        catch (JsonParseException | IOException var9) {
            field_53937.error("Failed to parse shader config at {}", (Object)resourceLocation, (Object)var9);
        }
    }

    private static void loadPostChain(class_2960 resourceLocation, class_3298 resource, ImmutableMap.Builder<class_2960, class_9962> builder) {
        class_2960 resourceLocation2 = field_53939.method_45115(resourceLocation);
        try (BufferedReader reader = resource.method_43039();){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            builder.put((Object)resourceLocation2, (Object)((class_9962)class_9962.field_53111.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonSyntaxException::new)));
        }
        catch (JsonParseException | IOException var9) {
            field_53937.error("Failed to parse post chain at {}", (Object)resourceLocation, (Object)var9);
        }
    }

    private static boolean isProgram(class_2960 resourceLocation) {
        return resourceLocation.method_12832().endsWith(".json");
    }

    private static boolean isShader(class_2960 resourceLocation) {
        return class_10141.class_282.method_62884((class_2960)resourceLocation) != null || resourceLocation.method_12832().endsWith(".glsl");
    }

    private static void loadShader(class_2960 resourceLocation, class_3298 resource, class_10141.class_282 type, Map<class_2960, class_3298> map, ImmutableMap.Builder<class_10151.class_10155, String> builder) {
        class_2960 resourceLocation2 = type.method_62885().method_45115(resourceLocation);
        class_5913 glslPreprocessor = ShaderManagerM.createPreprocessor(map, resourceLocation);
        try (BufferedReader reader = resource.method_43039();){
            String string = IOUtils.toString((Reader)reader);
            builder.put((Object)new class_10151.class_10155(resourceLocation2, type), (Object)String.join((CharSequence)"", glslPreprocessor.method_34229(string)));
        }
        catch (IOException var12) {
            field_53937.error("Failed to load shader source at {}", (Object)resourceLocation, (Object)var12);
        }
    }

    private static class_5944 createProgram(GraphicsPipeline pipeline) {
        class_5944 compiledShaderProgram = new class_5944(0);
        ShaderMixed shaderMixed = ShaderMixed.of(compiledShaderProgram);
        shaderMixed.setPipeline(pipeline);
        return compiledShaderProgram;
    }
}

