/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.mixin.render.shader;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Map;
import net.minecraft.class_10141;
import net.minecraft.class_10149;
import net.minecraft.class_10151;
import net.minecraft.class_10156;
import net.minecraft.class_10157;
import net.minecraft.class_2960;
import net.minecraft.class_5913;
import net.minecraft.class_5944;
import net.vulkanmod.Initializer;
import net.vulkanmod.interfaces.shader.PipelineConfig;
import net.vulkanmod.interfaces.shader.ShaderMixed;
import net.vulkanmod.render.shader.ShaderLoadUtil;
import net.vulkanmod.vulkan.shader.GraphicsPipeline;
import net.vulkanmod.vulkan.shader.Pipeline;
import net.vulkanmod.vulkan.shader.converter.GlslConverter;
import net.vulkanmod.vulkan.shader.descriptor.UBO;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_10151.class_10170.class})
public abstract class CompilationCacheM {
    @Shadow
    @Final
    private class_10151.class_10153 field_54022;
    @Shadow
    @Final
    public Map<class_10151.class_10154, class_10141> field_54024;

    @Inject(method={"compileProgram"}, at={@At(value="HEAD")}, cancellable=true)
    public void compileProgram(class_10156 shaderProgram, CallbackInfoReturnable<class_5944> cir) throws class_10151.class_10152 {
        class_10157 shaderProgramConfig = (class_10157)this.field_54022.comp_3105().get(shaderProgram.comp_3113());
        if (shaderProgramConfig == null) {
            throw new class_10151.class_10152("Could not find program with id: " + String.valueOf(shaderProgram.comp_3113()));
        }
        cir.setReturnValue((Object)this.createShaderProgram(shaderProgram, shaderProgramConfig));
    }

    private class_5944 createShaderProgram(class_10156 shaderProgram, class_10157 shaderProgramConfig) {
        String configName = PipelineConfig.of(shaderProgramConfig).getName();
        JsonObject config = ShaderLoadUtil.getJsonConfig("core", configName);
        if (config == null) {
            GlslConverter converter = new GlslConverter();
            Pipeline.Builder builder = new Pipeline.Builder(shaderProgram.comp_3114(), configName);
            class_10149 shaderDefines = shaderProgramConfig.comp_3120().method_62928(shaderProgram.comp_3115());
            String vshSrc = this.getShaderSource(shaderProgramConfig.comp_3116(), class_10141.class_282.field_1530, shaderDefines);
            String fshSrc = this.getShaderSource(shaderProgramConfig.comp_3117(), class_10141.class_282.field_1531, shaderDefines);
            converter.process(vshSrc, fshSrc);
            UBO ubo = converter.createUBO();
            builder.setUniforms(Collections.singletonList(ubo), converter.getSamplerList());
            builder.compileShaders(configName, converter.getVshConverted(), converter.getFshConverted());
            GraphicsPipeline pipeline = builder.createGraphicsPipeline();
            class_5944 compiledShaderProgram = CompilationCacheM.createProgram();
            compiledShaderProgram.method_62900(shaderProgramConfig.comp_3119(), shaderProgramConfig.comp_3118());
            ShaderMixed shaderMixed = ShaderMixed.of(compiledShaderProgram);
            shaderMixed.setPipeline(pipeline);
            shaderMixed.setupUniformSuppliers(ubo);
            shaderMixed.setUniformsUpdate();
            return compiledShaderProgram;
        }
        class_5944 compiledShaderProgram = CompilationCacheM.createProgram();
        compiledShaderProgram.method_62900(shaderProgramConfig.comp_3119(), shaderProgramConfig.comp_3118());
        ShaderMixed shaderMixed = ShaderMixed.of(compiledShaderProgram);
        Pipeline.Builder builder = new Pipeline.Builder(shaderProgram.comp_3114(), configName);
        builder.setUniformSupplierGetter(info -> shaderMixed.getUniformSupplier(info.name));
        builder.parseBindings(config);
        class_10149 shaderDefines = shaderProgramConfig.comp_3120().method_62928(shaderProgram.comp_3115());
        if (!shaderDefines.method_62930()) {
            Initializer.LOGGER.error("Shader {} is using external defines that are unsupported.", (Object)configName);
        }
        ShaderLoadUtil.loadShaders(builder, config, configName, "core");
        GraphicsPipeline pipeline = builder.createGraphicsPipeline();
        shaderMixed.setPipeline(pipeline);
        return compiledShaderProgram;
    }

    private String getShaderSource(class_2960 resourceLocation, class_10141.class_282 type, class_10149 shaderDefines) {
        class_10151.class_10154 shaderCompilationKey = new class_10151.class_10154(resourceLocation, type, shaderDefines);
        String source = (String)this.field_54022.comp_3106().get(new class_10151.class_10155(shaderCompilationKey.comp_3108(), shaderCompilationKey.comp_3109()));
        String processedSource = class_5913.method_62880((String)source, (class_10149)shaderCompilationKey.comp_3110());
        return processedSource;
    }

    private static class_5944 createProgram() {
        return new class_5944(0);
    }
}

