/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.config.option;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.vulkanmod.config.gui.widget.CyclingOptionWidget;
import net.vulkanmod.config.gui.widget.OptionWidget;
import net.vulkanmod.config.option.Option;
import org.apache.commons.lang3.ArrayUtils;

public class CyclingOption<E>
extends Option<E> {
    private E[] values;
    private int index;

    public CyclingOption(class_2561 name, E[] values, Consumer<E> setter, Supplier<E> getter) {
        super(name, setter, getter);
        this.values = values;
        this.index = this.findNewValueIndex();
    }

    @Override
    public OptionWidget<?> createOptionWidget(int x, int y, int width, int height) {
        return new CyclingOptionWidget(this, x, y, width, height, this.name);
    }

    public void updateOption(E[] values, Consumer<E> setter, Supplier<E> getter) {
        this.onApply = setter;
        this.valueSupplier = getter;
        this.values = values;
        this.index = ArrayUtils.indexOf((Object[])this.values, this.getNewValue());
    }

    public int index() {
        return this.index;
    }

    public void setValues(E[] values) {
        this.values = values;
    }

    public void prevValue() {
        if (this.index > 0) {
            --this.index;
        }
        this.updateValue();
    }

    public void nextValue() {
        if (this.index < this.values.length - 1) {
            ++this.index;
        }
        this.updateValue();
    }

    private void updateValue() {
        if (this.index >= 0 && this.index < this.values.length) {
            this.newValue = this.values[this.index];
            if (this.onChange != null) {
                this.onChange.run();
            }
        }
    }

    @Override
    public void setNewValue(E e) {
        super.setNewValue(e);
        this.index = this.findNewValueIndex();
    }

    private int findNewValueIndex() {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(this.newValue)) continue;
            return i;
        }
        return -1;
    }

    public E[] getValues() {
        return this.values;
    }
}

