/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.config.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.vulkanmod.Initializer;
import net.vulkanmod.config.gui.GuiRenderer;
import net.vulkanmod.config.gui.VOptionList;
import net.vulkanmod.config.gui.widget.VAbstractWidget;
import net.vulkanmod.config.gui.widget.VButtonWidget;
import net.vulkanmod.config.option.OptionPage;
import net.vulkanmod.config.option.Options;
import net.vulkanmod.vulkan.util.ColorUtil;

public class VOptionScreen
extends class_437 {
    public static final int RED = ColorUtil.ARGB.pack(0.3f, 0.0f, 0.0f, 0.8f);
    final class_2960 ICON = class_2960.method_60655((String)"vulkanmod", (String)"vlogo_transparent.png");
    private final class_437 parent;
    private final List<OptionPage> optionPages;
    private int currentListIdx = 0;
    private int tooltipX;
    private int tooltipY;
    private int tooltipWidth;
    private VButtonWidget supportButton;
    private VButtonWidget doneButton;
    private VButtonWidget applyButton;
    private final List<VButtonWidget> pageButtons = Lists.newArrayList();
    private final List<VButtonWidget> buttons = Lists.newArrayList();

    public VOptionScreen(class_2561 title, class_437 parent) {
        super(title);
        this.parent = parent;
        this.optionPages = new ArrayList<OptionPage>();
    }

    private void addPages() {
        this.optionPages.clear();
        OptionPage page = new OptionPage(class_2561.method_43471((String)"vulkanmod.options.pages.video").getString(), Options.getVideoOpts());
        this.optionPages.add(page);
        page = new OptionPage(class_2561.method_43471((String)"vulkanmod.options.pages.graphics").getString(), Options.getGraphicsOpts());
        this.optionPages.add(page);
        page = new OptionPage(class_2561.method_43471((String)"vulkanmod.options.pages.optimizations").getString(), Options.getOptimizationOpts());
        this.optionPages.add(page);
        page = new OptionPage(class_2561.method_43471((String)"vulkanmod.options.pages.other").getString(), Options.getOtherOpts());
        this.optionPages.add(page);
    }

    protected void method_25426() {
        this.addPages();
        int top = 40;
        int bottom = 60;
        int itemHeight = 20;
        int leftMargin = 100;
        int listWidth = Math.min((int)((float)this.field_22789 * 0.65f), 420);
        int listHeight = this.field_22790 - top - bottom;
        this.buildLists(leftMargin, top, listWidth, listHeight, itemHeight);
        int x = leftMargin + listWidth + 10;
        int width = this.field_22789 - x - 10;
        int y = 50;
        if (width < 200) {
            x = 100;
            width = listWidth;
            y = this.field_22790 - bottom + 10;
        }
        this.tooltipX = x;
        this.tooltipY = y;
        this.tooltipWidth = width;
        this.buildPage();
        this.applyButton.active = false;
    }

    private void buildLists(int left, int top, int listWidth, int listHeight, int itemHeight) {
        for (OptionPage page : this.optionPages) {
            page.createList(left, top, listWidth, listHeight, itemHeight);
        }
    }

    private void addPageButtons(int x0, int y0, int width, int height, boolean verticalLayout) {
        int x = x0;
        int y = y0;
        for (int i = 0; i < this.optionPages.size(); ++i) {
            OptionPage page = this.optionPages.get(i);
            int finalIdx = i;
            VButtonWidget widget = new VButtonWidget(x, y, width, height, class_2561.method_30163((String)page.name), button -> this.setOptionList(finalIdx));
            this.buttons.add(widget);
            this.pageButtons.add(widget);
            this.method_25429(widget);
            if (verticalLayout) {
                y += height + 1;
                continue;
            }
            x += width + 1;
        }
        this.pageButtons.get(this.currentListIdx).setSelected(true);
    }

    private void buildPage() {
        this.buttons.clear();
        this.pageButtons.clear();
        this.method_37067();
        this.addPageButtons(10, 40, 80, 22, true);
        VOptionList currentList = this.optionPages.get(this.currentListIdx).getOptionList();
        this.method_25429(currentList);
        this.addButtons();
    }

    private void addButtons() {
        int rightMargin = 20;
        int buttonHeight = 20;
        int padding = 10;
        int buttonMargin = 5;
        int buttonWidth = this.field_22787.field_1772.method_27525((class_5348)class_5244.field_24334) + 2 * padding;
        int x0 = this.field_22789 - buttonWidth - rightMargin;
        int y0 = this.field_22790 - buttonHeight - 7;
        this.doneButton = new VButtonWidget(x0, y0, buttonWidth, buttonHeight, class_5244.field_24334, button -> this.field_22787.method_1507(this.parent));
        buttonWidth = this.field_22787.field_1772.method_27525((class_5348)class_2561.method_43471((String)"vulkanmod.options.buttons.apply")) + 2 * padding;
        this.applyButton = new VButtonWidget(x0 -= buttonWidth + buttonMargin, y0, buttonWidth, buttonHeight, (class_2561)class_2561.method_43471((String)"vulkanmod.options.buttons.apply"), button -> this.applyOptions());
        buttonWidth = this.field_22787.field_1772.method_27525((class_5348)class_2561.method_43471((String)"vulkanmod.options.buttons.kofi")) + 10;
        x0 = this.field_22789 - buttonWidth - rightMargin;
        this.supportButton = new VButtonWidget(x0, 6, buttonWidth, buttonHeight, (class_2561)class_2561.method_43471((String)"vulkanmod.options.buttons.kofi"), button -> class_156.method_668().method_670("https://ko-fi.com/xcollateral"));
        this.buttons.add(this.applyButton);
        this.buttons.add(this.doneButton);
        this.buttons.add(this.supportButton);
        this.method_25429(this.applyButton);
        this.method_25429(this.doneButton);
        this.method_25429(this.supportButton);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_364 element : this.method_25396()) {
            if (!element.method_25402(mouseX, mouseY, button)) continue;
            this.method_25395(element);
            if (button == 0) {
                this.method_25398(true);
            }
            this.updateState();
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.method_25398(false);
        this.updateState();
        return this.method_19355(mouseX, mouseY).filter(guiEventListener -> guiEventListener.method_25406(mouseX, mouseY, button)).isPresent();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        if (this.field_22787.field_1687 == null) {
            this.method_57728(guiGraphics, f);
        }
        this.method_57734();
        this.method_57735(guiGraphics);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics, 0, 0, delta);
        GuiRenderer.guiGraphics = guiGraphics;
        GuiRenderer.setPoseStack(guiGraphics.method_51448());
        RenderSystem.enableBlend();
        Objects.requireNonNull(this.field_22787.field_1772);
        int size = 9 * 4;
        guiGraphics.method_25290(class_1921::method_62277, this.ICON, 30, 4, 0.0f, 0.0f, size, size, size, size);
        VOptionList currentList = this.optionPages.get(this.currentListIdx).getOptionList();
        currentList.updateState(mouseX, mouseY);
        currentList.renderWidget(mouseX, mouseY);
        this.renderButtons(mouseX, mouseY);
        List<class_5481> list = this.getHoveredButtonTooltip(currentList, mouseX, mouseY);
        if (list != null) {
            this.renderTooltip(list, this.tooltipX, this.tooltipY);
        }
    }

    public void renderButtons(int mouseX, int mouseY) {
        for (VButtonWidget button : this.buttons) {
            button.render(mouseX, mouseY);
        }
    }

    private void renderTooltip(List<class_5481> list, int x, int y) {
        int padding = 3;
        int width = GuiRenderer.getMaxTextWidth(this.field_22793, list);
        int height = list.size() * 10;
        float intensity = 0.05f;
        int color = ColorUtil.ARGB.pack(intensity, intensity, intensity, 0.6f);
        GuiRenderer.fill(x - padding, y - padding, x + width + padding, y + height + padding, color);
        color = RED;
        GuiRenderer.renderBorder(x - padding, y - padding, x + width + padding, y + height + padding, 1.0f, color);
        int yOffset = 0;
        for (class_5481 text : list) {
            GuiRenderer.drawString(this.field_22793, text, x, y + yOffset, -1);
            yOffset += 10;
        }
    }

    private List<class_5481> getHoveredButtonTooltip(VOptionList buttonList, int mouseX, int mouseY) {
        VAbstractWidget widget = buttonList.getHoveredWidget(mouseX, mouseY);
        if (widget != null) {
            class_2561 tooltip = widget.getTooltip();
            if (tooltip == null) {
                return null;
            }
            return this.field_22793.method_1728((class_5348)tooltip, this.tooltipWidth);
        }
        return null;
    }

    private void updateState() {
        boolean modified = false;
        for (OptionPage page : this.optionPages) {
            modified |= page.optionChanged();
        }
        this.applyButton.active = modified;
    }

    private void setOptionList(int i) {
        this.currentListIdx = i;
        this.buildPage();
        this.pageButtons.get(i).setSelected(true);
    }

    private void applyOptions() {
        List<OptionPage> pages = List.copyOf(this.optionPages);
        for (OptionPage page : pages) {
            page.applyOptionChanges();
        }
        Initializer.CONFIG.write();
    }
}

