/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.shader.converter;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_293;
import net.vulkanmod.vulkan.shader.converter.GlslConverter;
import net.vulkanmod.vulkan.shader.converter.UniformParser;

public class InputOutputParser {
    private final GlslConverter converterInstance;
    private class_293 vertexFormat;
    private final AttributeSet vertInAttributes = new AttributeSet();
    private final AttributeSet vertOutAttributes = new AttributeSet();
    private GlslConverter.ShaderStage shaderStage;
    private int currentLocation = 0;
    private String ioType;
    private String type;
    private String name;

    public InputOutputParser(GlslConverter converterInstance) {
        this.converterInstance = converterInstance;
    }

    public boolean parseToken(String token) {
        if (this.ioType == null) {
            this.ioType = token;
        } else if (this.type == null) {
            this.type = token;
        } else if (this.name == null) {
            this.name = token = UniformParser.removeSemicolon(token);
            if (this.shaderStage == GlslConverter.ShaderStage.Vertex) {
                switch (this.ioType) {
                    case "in": {
                        this.vertInAttributes.add(this.type, this.name);
                        break;
                    }
                    case "out": {
                        this.vertOutAttributes.add(this.type, this.name);
                    }
                }
            } else {
                switch (this.ioType) {
                    case "in": {
                        if (this.vertOutAttributes.contains(this.type, this.name)) break;
                        throw new RuntimeException("fragment in attribute does not match vertex output");
                    }
                }
            }
            this.resetState();
            return true;
        }
        return false;
    }

    private void resetState() {
        this.ioType = null;
        this.type = null;
        this.name = null;
    }

    public String createInOutCode() {
        StringBuilder builder = new StringBuilder();
        if (this.shaderStage == GlslConverter.ShaderStage.Vertex) {
            for (Attribute attribute : this.vertInAttributes.attributes) {
                builder.append(String.format("layout(location = %d) in %s %s;\n", attribute.location, attribute.type, attribute.name));
            }
            builder.append("\n");
            for (Attribute attribute : this.vertOutAttributes.attributes) {
                builder.append(String.format("layout(location = %d) out %s %s;\n", attribute.location, attribute.type, attribute.name));
            }
            builder.append("\n");
        } else {
            for (Attribute attribute : this.vertOutAttributes.attributes) {
                builder.append(String.format("layout(location = %d) in %s %s;\n", attribute.location, attribute.type, attribute.name));
            }
            builder.append("\n");
            builder.append(String.format("layout(location = 0) out vec4 fragColor;\n\n", new Object[0]));
        }
        return builder.toString();
    }

    public void setShaderStage(GlslConverter.ShaderStage shaderStage) {
        this.shaderStage = shaderStage;
    }

    static class AttributeSet {
        List<Attribute> attributes = new ObjectArrayList();
        int currentLocation = 0;

        AttributeSet() {
        }

        void add(String type, String name) {
            this.attributes.add(new Attribute(this.currentLocation, type, name));
            ++this.currentLocation;
        }

        boolean contains(String type, String name) {
            return this.attributes.stream().anyMatch(attribute -> Objects.equals(attribute.name, name) && Objects.equals(attribute.type, type));
        }
    }

    public record Attribute(int location, String type, String name) {
    }
}

