/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.shader.converter;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class CodeParser {
    public static String parseCodeLine(String line) {
        String token;
        LinkedList<String> tokens = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, " \t\n\r\f,(){}%", true);
        String delims = " \t\n\r\f";
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (delims.contains(token)) continue;
            tokens.add(token);
        }
        ObjectArrayList processed = new ObjectArrayList();
        boolean changed = false;
        int i = 0;
        while (i < tokens.size()) {
            token = (String)tokens.get(i);
            if (token.equals("%")) {
                processed.removeLast();
                String prevToken = (String)tokens.get(i - 1);
                String nextToken = (String)tokens.get(i + 1);
                prevToken = CodeParser.checkTokenMapping(prevToken);
                nextToken = CodeParser.checkTokenMapping(nextToken);
                String newToken = "mod(%s, %s)".formatted(prevToken, nextToken);
                processed.add(newToken);
                changed = true;
                i += 2;
                continue;
            }
            String remappedToken = CodeParser.checkTokenMapping(token);
            if (!remappedToken.equals(token)) {
                changed = true;
            }
            processed.add(remappedToken + " ");
            ++i;
        }
        if (changed) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String s : processed) {
                stringBuilder.append(s);
            }
            return stringBuilder.toString();
        }
        return line;
    }

    private static String checkTokenMapping(String token) {
        return switch (token) {
            case "gl_VertexID" -> "gl_VertexIndex";
            default -> token;
        };
    }
}

