/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.shader;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.function.Supplier;
import net.vulkanmod.vulkan.VRenderSystem;
import net.vulkanmod.vulkan.util.MappedBuffer;

public class Uniforms {
    public static Object2ReferenceOpenHashMap<String, Supplier<Integer>> vec1i_uniformMap = new Object2ReferenceOpenHashMap();
    public static Object2ReferenceOpenHashMap<String, Supplier<Float>> vec1f_uniformMap = new Object2ReferenceOpenHashMap();
    public static Object2ReferenceOpenHashMap<String, Supplier<MappedBuffer>> vec2f_uniformMap = new Object2ReferenceOpenHashMap();
    public static Object2ReferenceOpenHashMap<String, Supplier<MappedBuffer>> vec3f_uniformMap = new Object2ReferenceOpenHashMap();
    public static Object2ReferenceOpenHashMap<String, Supplier<MappedBuffer>> vec4f_uniformMap = new Object2ReferenceOpenHashMap();
    public static Object2ReferenceOpenHashMap<String, Supplier<MappedBuffer>> mat4f_uniformMap = new Object2ReferenceOpenHashMap();

    public static void setupDefaultUniforms() {
        mat4f_uniformMap.put((Object)"ModelViewMat", VRenderSystem::getModelViewMatrix);
        mat4f_uniformMap.put((Object)"ProjMat", VRenderSystem::getProjectionMatrix);
        mat4f_uniformMap.put((Object)"MVP", VRenderSystem::getMVP);
        mat4f_uniformMap.put((Object)"TextureMat", VRenderSystem::getTextureMatrix);
        vec1i_uniformMap.put((Object)"EndPortalLayers", () -> 15);
        vec1i_uniformMap.put((Object)"FogShape", () -> RenderSystem.getShaderFog().comp_3011().method_40036());
        vec1f_uniformMap.put((Object)"FogStart", () -> Float.valueOf(RenderSystem.getShaderFog().comp_3009()));
        vec1f_uniformMap.put((Object)"FogEnd", () -> Float.valueOf(RenderSystem.getShaderFog().comp_3010()));
        vec1f_uniformMap.put((Object)"LineWidth", RenderSystem::getShaderLineWidth);
        vec1f_uniformMap.put((Object)"GameTime", RenderSystem::getShaderGameTime);
        vec1f_uniformMap.put((Object)"GlintAlpha", RenderSystem::getShaderGlintAlpha);
        vec1f_uniformMap.put((Object)"AlphaCutout", () -> Float.valueOf(VRenderSystem.alphaCutout));
        vec2f_uniformMap.put((Object)"ScreenSize", VRenderSystem::getScreenSize);
        vec3f_uniformMap.put((Object)"Light0_Direction", () -> VRenderSystem.lightDirection0);
        vec3f_uniformMap.put((Object)"Light1_Direction", () -> VRenderSystem.lightDirection1);
        vec3f_uniformMap.put((Object)"ModelOffset", () -> VRenderSystem.modelOffset);
        vec4f_uniformMap.put((Object)"ColorModulator", VRenderSystem::getShaderColor);
        vec4f_uniformMap.put((Object)"FogColor", VRenderSystem::getShaderFogColor);
    }

    public static Supplier<MappedBuffer> getUniformSupplier(String type, String name) {
        return switch (type) {
            case "mat4" -> (Supplier)mat4f_uniformMap.get((Object)name);
            case "vec4" -> (Supplier)vec4f_uniformMap.get((Object)name);
            case "vec3" -> (Supplier)vec3f_uniformMap.get((Object)name);
            case "vec2" -> (Supplier)vec2f_uniformMap.get((Object)name);
            default -> null;
        };
    }
}

