/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.memory;

import java.nio.ByteBuffer;
import net.vulkanmod.vulkan.memory.Buffer;
import net.vulkanmod.vulkan.memory.MemoryManager;
import net.vulkanmod.vulkan.memory.MemoryType;

public class IndexBuffer
extends Buffer {
    public IndexType indexType;

    public IndexBuffer(int size, MemoryType type) {
        this(size, type, IndexType.SHORT);
    }

    public IndexBuffer(int size, MemoryType type, IndexType indexType) {
        super(64, type);
        this.indexType = indexType;
        this.createBuffer(size);
    }

    public void copyBuffer(ByteBuffer byteBuffer) {
        int size = byteBuffer.remaining();
        if ((long)size > this.bufferSize - this.usedBytes) {
            this.resizeBuffer((this.bufferSize + (long)size) * 2L);
        }
        this.type.copyToBuffer(this, size, byteBuffer);
        this.offset = this.usedBytes;
        this.usedBytes += (long)size;
    }

    private void resizeBuffer(long newSize) {
        MemoryManager.getInstance().addToFreeable(this);
        this.createBuffer(newSize);
    }

    public static enum IndexType {
        SHORT(2, 0),
        INT(4, 1);

        public final int size;
        public final int type;

        private IndexType(int size, int type) {
            this.size = size;
            this.type = type;
        }
    }
}

