/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.memory;

import net.vulkanmod.vulkan.memory.MemoryManager;
import net.vulkanmod.vulkan.memory.MemoryType;

public abstract class Buffer {
    protected long id;
    protected long allocation;
    protected long bufferSize;
    protected long usedBytes;
    protected long offset;
    protected MemoryType type;
    protected int usage;
    protected long dataPtr;

    protected Buffer(int usage, MemoryType type) {
        this.usage = usage;
        this.type = type;
    }

    protected void createBuffer(long bufferSize) {
        this.type.createBuffer(this, bufferSize);
        if (this.type.mappable()) {
            this.dataPtr = MemoryManager.getInstance().Map(this.allocation).get(0);
        }
    }

    public void scheduleFree() {
        MemoryManager.getInstance().addToFreeable(this);
    }

    public void reset() {
        this.usedBytes = 0L;
    }

    public long getAllocation() {
        return this.allocation;
    }

    public long getUsedBytes() {
        return this.usedBytes;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getId() {
        return this.id;
    }

    public long getBufferSize() {
        return this.bufferSize;
    }

    public long getDataPtr() {
        return this.dataPtr;
    }

    protected void setBufferSize(long size) {
        this.bufferSize = size;
    }

    protected void setId(long id) {
        this.id = id;
    }

    protected void setAllocation(long allocation) {
        this.allocation = allocation;
    }

    public BufferInfo getBufferInfo() {
        return new BufferInfo(this.id, this.allocation, this.bufferSize, this.type.getType());
    }

    public record BufferInfo(long id, long allocation, long bufferSize, MemoryType.Type type) {
    }
}

