/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk.build.renderer;

import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.ShadeMode;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_6575;
import net.vulkanmod.Initializer;
import net.vulkanmod.render.chunk.build.frapi.material.RenderMaterialImpl;
import net.vulkanmod.render.chunk.build.frapi.mesh.MutableQuadViewImpl;
import net.vulkanmod.render.chunk.build.frapi.render.AbstractBlockRenderContext;
import net.vulkanmod.render.chunk.build.light.LightPipeline;
import net.vulkanmod.render.chunk.build.light.data.QuadLightData;
import net.vulkanmod.render.chunk.build.thread.BuilderResources;
import net.vulkanmod.render.chunk.cull.QuadFacing;
import net.vulkanmod.render.model.quad.ModelQuadView;
import net.vulkanmod.render.model.quad.QuadUtils;
import net.vulkanmod.render.vertex.TerrainBufferBuilder;
import net.vulkanmod.render.vertex.TerrainBuilder;
import net.vulkanmod.render.vertex.TerrainRenderType;
import net.vulkanmod.render.vertex.format.I32_SNorm;
import net.vulkanmod.vulkan.util.ColorUtil;
import org.joml.Vector3f;

public class BlockRenderer
extends AbstractBlockRenderContext {
    private Vector3f pos;
    private BuilderResources resources;
    private TerrainBuilder terrainBuilder;
    final boolean backFaceCulling;
    private TerrainRenderType renderType;

    public void setResources(BuilderResources resources) {
        this.resources = resources;
    }

    public BlockRenderer(LightPipeline flatLightPipeline, LightPipeline smoothLightPipeline) {
        this.backFaceCulling = Initializer.CONFIG.backFaceCulling;
        this.setupLightPipelines(flatLightPipeline, smoothLightPipeline);
        this.random = new class_6575(42L);
    }

    public void renderBlock(class_2680 blockState, class_2338 blockPos, Vector3f pos) {
        this.pos = pos;
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.seed = blockState.method_26190(blockPos);
        TerrainRenderType renderType = TerrainRenderType.get(class_4696.method_23679((class_2680)blockState));
        this.renderType = renderType = TerrainRenderType.getRemapped(renderType);
        this.terrainBuilder = this.resources.builderPack.builder(renderType);
        this.terrainBuilder.setBlockAttributes(blockState);
        class_1087 model = class_310.method_1551().method_1541().method_3349(blockState);
        class_1920 renderRegion = this.renderRegion;
        class_243 offset = blockState.method_26226(blockPos);
        pos.add((float)offset.field_1352, (float)offset.field_1351, (float)offset.field_1350);
        this.prepareForBlock(blockState, blockPos, model.method_4708());
        model.emitBlockQuads(renderRegion, blockState, blockPos, this.randomSupplier, (RenderContext)this);
    }

    @Override
    protected void endRenderQuad(MutableQuadViewImpl quad) {
        RenderMaterialImpl mat = quad.material();
        int colorIndex = mat.disableColorIndex() ? -1 : quad.colorIndex();
        TriState aoMode = mat.ambientOcclusion();
        boolean ao = this.useAO && (aoMode == TriState.TRUE || aoMode == TriState.DEFAULT && this.defaultAO);
        boolean emissive = mat.emissive();
        boolean vanillaShade = mat.shadeMode() == ShadeMode.VANILLA;
        TerrainBuilder terrainBuilder = this.getBufferBuilder(mat.blendMode());
        LightPipeline lightPipeline = ao ? this.smoothLightPipeline : this.flatLightPipeline;
        this.colorizeQuad(quad, colorIndex);
        this.shadeQuad(quad, lightPipeline, emissive, vanillaShade);
        this.bufferQuad(terrainBuilder, this.pos, quad, this.quadLightData);
    }

    private TerrainBuilder getBufferBuilder(BlendMode blendMode) {
        if (blendMode == BlendMode.DEFAULT) {
            return this.terrainBuilder;
        }
        TerrainRenderType renderType = TerrainRenderType.get(blendMode.blockRenderLayer);
        renderType = TerrainRenderType.getRemapped(renderType);
        TerrainBuilder bufferBuilder = this.resources.builderPack.builder(renderType);
        bufferBuilder.setBlockAttributes(this.blockState);
        return bufferBuilder;
    }

    public void bufferQuad(TerrainBuilder terrainBuilder, Vector3f pos, ModelQuadView quad, QuadLightData quadLightData) {
        QuadFacing quadFacing = quad.getQuadFacing();
        if (this.renderType == TerrainRenderType.TRANSLUCENT || !this.backFaceCulling) {
            quadFacing = QuadFacing.UNDEFINED;
        }
        TerrainBufferBuilder bufferBuilder = terrainBuilder.getBufferBuilder(quadFacing.ordinal());
        class_2382 normal = quad.getFacingDirection().method_62675();
        int packedNormal = I32_SNorm.packNormal(normal.method_10263(), normal.method_10264(), normal.method_10260());
        float[] brightnessArr = quadLightData.br;
        int[] lights = quadLightData.lm;
        int idx = QuadUtils.getIterationStartIdx(brightnessArr, lights);
        bufferBuilder.ensureCapacity();
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            float x = pos.x() + quad.getX(idx);
            float y = pos.y() + quad.getY(idx);
            float z = pos.z() + quad.getZ(idx);
            int quadColor = quad.getColor(idx);
            int color = ColorUtil.ARGB.toRGBA(quadColor);
            int light = lights[idx];
            float u = quad.getU(idx);
            float v = quad.getV(idx);
            bufferBuilder.vertex(x, y, z, color, u, v, light, packedNormal);
            idx = idx + 1 & 3;
        }
    }
}

