/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk.build.light.smooth;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.vulkanmod.render.chunk.build.light.LightPipeline;
import net.vulkanmod.render.chunk.build.light.data.LightDataAccess;
import net.vulkanmod.render.chunk.build.light.data.QuadLightData;
import net.vulkanmod.render.chunk.build.light.smooth.AoNeighborInfo;
import net.vulkanmod.render.chunk.build.light.smooth.SubBlockAoFace;
import net.vulkanmod.render.chunk.util.SimpleDirection;
import net.vulkanmod.render.model.quad.ModelQuadView;

public class NewSmoothLightPipeline
implements LightPipeline {
    private final LightDataAccess lightCache;
    private final SubBlockAoFace[] cachedFaceData = new SubBlockAoFace[12];
    private final SubBlockAoFace self = new SubBlockAoFace();
    private long cachedPos = Long.MIN_VALUE;
    private final float[] weights = new float[4];

    public NewSmoothLightPipeline(LightDataAccess cache) {
        this.lightCache = cache;
        for (int i = 0; i < this.cachedFaceData.length; ++i) {
            this.cachedFaceData[i] = new SubBlockAoFace();
        }
    }

    @Override
    public void calculate(ModelQuadView quad, class_2338 pos, QuadLightData out, class_2350 cullFace, class_2350 lightFaceO, boolean shade) {
        this.updateCachedData(pos.method_10063());
        int flags = quad.getFlags();
        SimpleDirection lightFace = SimpleDirection.of(lightFaceO);
        AoNeighborInfo neighborInfo = AoNeighborInfo.get(lightFace);
        if ((flags & 4) != 0 || (flags & 2) != 0 && LightDataAccess.unpackFC(this.lightCache.get(pos))) {
            if ((flags & 1) == 0) {
                this.applyAlignedFullFace(neighborInfo, pos, lightFace, out);
            } else {
                this.applyAlignedPartialFace(neighborInfo, quad, pos, lightFace, out);
            }
        } else if ((flags & 2) != 0) {
            this.applyParallelFace(neighborInfo, quad, pos, lightFace, out);
        } else {
            this.applyNonParallelFace(neighborInfo, quad, pos, lightFace, out);
        }
        this.applySidedBrightness(out, lightFaceO, shade);
    }

    private void applyAlignedFullFace(AoNeighborInfo neighborInfo, class_2338 pos, SimpleDirection dir, QuadLightData out) {
        SubBlockAoFace faceData = this.getCachedFaceData(pos, dir, true);
        neighborInfo.copyLightValues(faceData.lm, faceData.ao, out.lm, out.br);
    }

    private void applyAlignedPartialFace(AoNeighborInfo neighborInfo, ModelQuadView quad, class_2338 pos, SimpleDirection dir, QuadLightData out) {
        for (int i = 0; i < 4; ++i) {
            float cx = NewSmoothLightPipeline.clamp(quad.getX(i));
            float cy = NewSmoothLightPipeline.clamp(quad.getY(i));
            float cz = NewSmoothLightPipeline.clamp(quad.getZ(i));
            float[] weights = this.weights;
            neighborInfo.calculateCornerWeights(cx, cy, cz, weights);
            this.applyAlignedPartialFaceVertex(pos, dir, weights, i, out, true);
        }
    }

    private void applyParallelFace(AoNeighborInfo neighborInfo, ModelQuadView quad, class_2338 pos, SimpleDirection dir, QuadLightData out) {
        this.self.calculateSelfOcclusion(this.lightCache, pos, dir);
        for (int i = 0; i < 4; ++i) {
            float cx = NewSmoothLightPipeline.clamp(quad.getX(i));
            float cy = NewSmoothLightPipeline.clamp(quad.getY(i));
            float cz = NewSmoothLightPipeline.clamp(quad.getZ(i));
            float[] weights = this.weights;
            neighborInfo.calculateCornerWeights(cx, cy, cz, weights);
            float depth = neighborInfo.getDepth(cx, cy, cz);
            if (class_3532.method_15347((float)depth, (float)1.0f)) {
                this.applyAlignedPartialFaceVertex(pos, dir, weights, i, out, false);
                continue;
            }
            this.applyInsetPartialFaceVertexSO(pos, dir, depth, 1.0f - depth, weights, i, out);
        }
    }

    private void applyNonParallelFace(AoNeighborInfo neighborInfo, ModelQuadView quad, class_2338 pos, SimpleDirection dir, QuadLightData out) {
        for (int i = 0; i < 4; ++i) {
            float cx = NewSmoothLightPipeline.clamp(quad.getX(i));
            float cy = NewSmoothLightPipeline.clamp(quad.getY(i));
            float cz = NewSmoothLightPipeline.clamp(quad.getZ(i));
            float[] weights = this.weights;
            neighborInfo.calculateCornerWeights(cx, cy, cz, weights);
            float depth = neighborInfo.getDepth(cx, cy, cz);
            if (class_3532.method_15347((float)depth, (float)0.0f)) {
                this.applyAlignedPartialFaceVertex(pos, dir, weights, i, out, true);
                continue;
            }
            if (class_3532.method_15347((float)depth, (float)1.0f)) {
                this.applyAlignedPartialFaceVertex(pos, dir, weights, i, out, false);
                continue;
            }
            this.applyInsetPartialFaceVertex(pos, dir, depth, 1.0f - depth, weights, i, out);
        }
    }

    private void applyAlignedPartialFaceVertex(class_2338 pos, SimpleDirection dir, float[] w, int i, QuadLightData out, boolean offset) {
        float ao;
        SubBlockAoFace faceData = this.getCachedFaceData(pos, dir, offset);
        if (!faceData.hasUnpackedLightData()) {
            faceData.unpackLightData();
        }
        float sl = faceData.getBlendedSkyLight(w);
        float bl = faceData.getBlendedBlockLight(w);
        out.br[i] = ao = faceData.getBlendedShade(w);
        out.lm[i] = NewSmoothLightPipeline.packLightMap(sl, bl);
    }

    private void applyInsetPartialFaceVertex(class_2338 pos, SimpleDirection dir, float n1d, float n2d, float[] w, int i, QuadLightData out) {
        SubBlockAoFace n2;
        SubBlockAoFace n1 = this.getCachedFaceData(pos, dir, false);
        if (!n1.hasUnpackedLightData()) {
            n1.unpackLightData();
        }
        if (!(n2 = this.getCachedFaceData(pos, dir, true)).hasUnpackedLightData()) {
            n2.unpackLightData();
        }
        float ao = n1.getBlendedShade(w) * n1d + n2.getBlendedShade(w) * n2d;
        float sl = n1.getBlendedSkyLight(w) * n1d + n2.getBlendedSkyLight(w) * n2d;
        float bl = n1.getBlendedBlockLight(w) * n1d + n2.getBlendedBlockLight(w) * n2d;
        out.br[i] = ao;
        out.lm[i] = NewSmoothLightPipeline.packLightMap(sl, bl);
    }

    private void applyInsetPartialFaceVertexSO(class_2338 pos, SimpleDirection dir, float n1d, float n2d, float[] w, int i, QuadLightData out) {
        SubBlockAoFace n2;
        SubBlockAoFace n1 = this.getCachedFaceData(pos, dir, false);
        if (!n1.hasUnpackedLightData()) {
            n1.unpackLightData();
        }
        if (!(n2 = this.getCachedFaceData(pos, dir, true)).hasUnpackedLightData()) {
            n2.unpackLightData();
        }
        float ao = n1.getBlendedShade(w) * n1d + n2.getBlendedShade(w) * n2d;
        float sl = n1.getBlendedSkyLight(w) * n1d + n2.getBlendedSkyLight(w) * n2d;
        float bl = n1.getBlendedBlockLight(w) * n1d + n2.getBlendedBlockLight(w) * n2d;
        out.br[i] = ao = Math.min(ao, this.self.getBlendedShade(w));
        out.lm[i] = NewSmoothLightPipeline.packLightMap(sl, bl);
    }

    private void applySidedBrightness(QuadLightData out, class_2350 face, boolean shade) {
        float brightness = this.lightCache.getRegion().method_24852(face, shade);
        float[] br = out.br;
        int i = 0;
        while (i < br.length) {
            int n = i++;
            br[n] = br[n] * brightness;
        }
    }

    private SubBlockAoFace getCachedFaceData(class_2338 pos, SimpleDirection face, boolean offset) {
        SubBlockAoFace data = this.cachedFaceData[offset ? face.ordinal() : face.ordinal() + 6];
        if (!data.hasLightData()) {
            data.initLightData(this.lightCache, pos, face, offset);
        }
        return data;
    }

    private void updateCachedData(long key) {
        if (this.cachedPos != key) {
            for (SubBlockAoFace data : this.cachedFaceData) {
                data.reset();
            }
            this.cachedPos = key;
        }
    }

    private static float clamp(float v) {
        if (v < 0.0f) {
            return 0.0f;
        }
        if (v > 1.0f) {
            return 1.0f;
        }
        return v;
    }

    private static int packLightMap(float sl, float bl) {
        return ((int)sl & 0xFF) << 16 | (int)bl & 0xFF;
    }
}

