/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.mixin.debug;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_340;
import net.vulkanmod.Initializer;
import net.vulkanmod.render.chunk.WorldRenderer;
import net.vulkanmod.vulkan.SystemInfo;
import net.vulkanmod.vulkan.Vulkan;
import net.vulkanmod.vulkan.device.Device;
import net.vulkanmod.vulkan.memory.MemoryManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_340.class})
public abstract class DebugScreenOverlayM {
    @Shadow
    @Final
    private class_310 field_2079;
    @Shadow
    @Final
    private class_327 field_2081;

    @Shadow
    private static long method_1838(long bytes) {
        return 0L;
    }

    @Shadow
    protected abstract List<String> method_1835();

    @Shadow
    protected abstract List<String> method_1839();

    @Redirect(method={"getSystemInformation"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList([Ljava/lang/Object;)Ljava/util/ArrayList;"))
    private ArrayList<String> redirectList(Object[] elements) {
        ArrayList<String> strings = new ArrayList<String>();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        Device device = Vulkan.getDevice();
        strings.add(String.format("Java: %s", System.getProperty("java.version")));
        strings.add(String.format("Mem: % 2d%% %03d/%03dMB", usedMemory * 100L / maxMemory, DebugScreenOverlayM.method_1838(usedMemory), DebugScreenOverlayM.method_1838(maxMemory)));
        strings.add(String.format("Allocated: % 2d%% %03dMB", totalMemory * 100L / maxMemory, DebugScreenOverlayM.method_1838(totalMemory)));
        strings.add(String.format("Off-heap: " + this.getOffHeapMemory() + "MB", new Object[0]));
        strings.add("NativeMemory: %dMB".formatted(MemoryManager.getInstance().getNativeMemoryMB()));
        strings.add("DeviceMemory: %dMB".formatted(MemoryManager.getInstance().getAllocatedDeviceMemoryMB()));
        strings.add("");
        strings.add("VulkanMod " + Initializer.getVersion());
        strings.add("CPU: " + SystemInfo.cpuInfo);
        strings.add("GPU: " + device.deviceName);
        strings.add("Driver: " + device.driverVersion);
        strings.add("Vulkan: " + device.vkVersion);
        strings.add("");
        strings.add("");
        Collections.addAll(strings, WorldRenderer.getInstance().getChunkAreaManager().getStats());
        return strings;
    }

    private long getOffHeapMemory() {
        return DebugScreenOverlayM.method_1838(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed());
    }
}

