/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.gl;

import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.vulkanmod.gl.GlRenderbuffer;
import net.vulkanmod.gl.GlTexture;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.VRenderSystem;
import net.vulkanmod.vulkan.framebuffer.Framebuffer;
import net.vulkanmod.vulkan.framebuffer.RenderPass;
import net.vulkanmod.vulkan.texture.ImageUtil;
import net.vulkanmod.vulkan.texture.VulkanImage;

public class GlFramebuffer {
    private static int idCounter = 1;
    private static final Int2ReferenceOpenHashMap<GlFramebuffer> map = new Int2ReferenceOpenHashMap();
    private static GlFramebuffer boundFramebuffer;
    private static GlFramebuffer readFramebuffer;
    private final int id;
    Framebuffer framebuffer;
    RenderPass renderPass;
    VulkanImage colorAttachment;
    VulkanImage depthAttachment;

    public static void resetBoundFramebuffer() {
        boundFramebuffer = null;
    }

    public static void beginRendering(GlFramebuffer glFramebuffer) {
        boolean begunRendering = glFramebuffer.beginRendering();
        if (begunRendering) {
            Framebuffer framebuffer = glFramebuffer.framebuffer;
            int viewWidth = framebuffer.getWidth();
            int viewHeight = framebuffer.getHeight();
            Renderer.setInvertedViewport(0, 0, viewWidth, viewHeight);
            Renderer.setScissor(0, 0, viewWidth, viewHeight);
            VRenderSystem.disableCull();
        }
        boundFramebuffer = glFramebuffer;
    }

    public static int genFramebufferId() {
        int id = idCounter++;
        map.put(id, (Object)new GlFramebuffer(id));
        return id;
    }

    public static void bindFramebuffer(int target, int id) {
        if (id == 0) {
            Renderer.getInstance().endRenderPass();
            if (Renderer.isRecording()) {
                class_276 renderTarget = class_310.method_1551().method_1522();
                renderTarget.method_1235(true);
            }
            boundFramebuffer = null;
            return;
        }
        GlFramebuffer glFramebuffer = (GlFramebuffer)map.get(id);
        if (glFramebuffer == null) {
            throw new NullPointerException("No Framebuffer with ID: %d ".formatted(id));
        }
        switch (target) {
            case 36009: 
            case 36160: {
                if (glFramebuffer.framebuffer != null) {
                    GlFramebuffer.beginRendering(glFramebuffer);
                }
                boundFramebuffer = glFramebuffer;
                break;
            }
            case 36008: {
                readFramebuffer = glFramebuffer;
            }
        }
    }

    public static void deleteFramebuffer(int id) {
        if (id == 0) {
            return;
        }
        boundFramebuffer = (GlFramebuffer)map.remove(id);
        if (boundFramebuffer == null) {
            throw new NullPointerException("bound framebuffer is null");
        }
        boundFramebuffer.cleanUp(true);
        boundFramebuffer = null;
    }

    public static void framebufferTexture2D(int target, int attachment, int texTarget, int texture, int level) {
        if (attachment != 36064 && attachment != 36096) {
            throw new UnsupportedOperationException();
        }
        if (texTarget != 3553) {
            throw new UnsupportedOperationException();
        }
        if (level != 0) {
            throw new UnsupportedOperationException();
        }
        boundFramebuffer.setAttachmentTexture(attachment, texture);
    }

    public static void framebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        if (boundFramebuffer == null) {
            return;
        }
        boundFramebuffer.setAttachmentRenderbuffer(attachment, renderbuffer);
    }

    public static void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        ImageUtil.blitFramebuffer(GlFramebuffer.boundFramebuffer.colorAttachment, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1);
    }

    public static int glCheckFramebufferStatus(int target) {
        return 36053;
    }

    public static GlFramebuffer getBoundFramebuffer() {
        return boundFramebuffer;
    }

    public static GlFramebuffer getFramebuffer(int id) {
        return (GlFramebuffer)map.get(id);
    }

    GlFramebuffer(int i) {
        this.id = i;
    }

    boolean beginRendering() {
        return Renderer.getInstance().beginRendering(this.renderPass, this.framebuffer);
    }

    void setAttachmentTexture(int attachment, int texture) {
        GlTexture glTexture = GlTexture.getTexture(texture);
        if (glTexture == null) {
            throw new NullPointerException(String.format("Texture %d is null", texture));
        }
        if (glTexture.vulkanImage == null) {
            return;
        }
        switch (attachment) {
            case 36064: {
                this.setColorAttachment(glTexture.getVulkanImage());
                break;
            }
            case 36096: {
                this.setDepthAttachment(glTexture.getVulkanImage());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + attachment);
            }
        }
    }

    void setAttachmentRenderbuffer(int attachment, int texture) {
        GlRenderbuffer renderbuffer = GlRenderbuffer.getRenderbuffer(texture);
        if (renderbuffer == null) {
            throw new NullPointerException(String.format("Texture %d is null", texture));
        }
        if (renderbuffer.vulkanImage == null) {
            return;
        }
        switch (attachment) {
            case 36064: {
                this.setColorAttachment(renderbuffer.getVulkanImage());
                break;
            }
            case 36096: {
                this.setDepthAttachment(renderbuffer.getVulkanImage());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + attachment);
            }
        }
    }

    void setColorAttachment(VulkanImage image) {
        this.colorAttachment = image;
        this.createAndBind();
    }

    void setDepthAttachment(VulkanImage image) {
        this.depthAttachment = image;
        this.createAndBind();
    }

    void createAndBind() {
        if (this.colorAttachment == null) {
            return;
        }
        if (this.framebuffer != null) {
            this.cleanUp(false);
        }
        boolean hasDepthImage = this.depthAttachment != null;
        VulkanImage depthImage = this.depthAttachment;
        this.framebuffer = Framebuffer.builder(this.colorAttachment, depthImage).build();
        RenderPass.Builder builder = RenderPass.builder(this.framebuffer);
        builder.getColorAttachmentInfo().setLoadOp(0).setFinalLayout(5);
        if (hasDepthImage) {
            builder.getDepthAttachmentInfo().setOps(0, 0);
        }
        this.renderPass = builder.build();
        GlFramebuffer.beginRendering(this);
    }

    public Framebuffer getFramebuffer() {
        return this.framebuffer;
    }

    public RenderPass getRenderPass() {
        return this.renderPass;
    }

    void cleanUp(boolean freeAttachments) {
        this.framebuffer.cleanUp(freeAttachments);
        this.renderPass.cleanUp();
        this.framebuffer = null;
        this.renderPass = null;
    }
}

