/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.gl;

import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.system.MemoryUtil;

public class GlBuffer {
    private static int ID_COUNTER = 1;
    private static final Int2ReferenceOpenHashMap<GlBuffer> map = new Int2ReferenceOpenHashMap();
    private static int boundId = 0;
    private static GlBuffer boundBuffer;
    private static GlBuffer pixelPackBufferBound;
    private static GlBuffer pixelUnpackBufferBound;
    int id;
    int target;
    ByteBuffer data;

    public static int glGenBuffers() {
        int id = ID_COUNTER++;
        map.put(id, (Object)new GlBuffer(id));
        return id;
    }

    public static void glBindBuffer(int target, int buffer) {
        boundId = buffer;
        GlBuffer glBuffer = (GlBuffer)map.get(buffer);
        if (buffer > 0 && glBuffer == null) {
            throw new NullPointerException("bound texture is null");
        }
        if (glBuffer != null) {
            glBuffer.target = target;
        }
        switch (target) {
            case 35051: {
                pixelPackBufferBound = glBuffer;
                break;
            }
            case 35052: {
                pixelUnpackBufferBound = glBuffer;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + target);
            }
        }
    }

    public static void glBufferData(int target, ByteBuffer byteBuffer, int usage) {
        GlBuffer.checkTarget(target);
        pixelUnpackBufferBound = boundBuffer;
    }

    public static void glBufferData(int target, long size, int usage) {
        GlBuffer buffer = switch (target) {
            case 35051 -> pixelPackBufferBound;
            case 35052 -> pixelUnpackBufferBound;
            default -> throw new IllegalStateException("Unexpected value: " + target);
        };
        buffer.allocate((int)size);
    }

    public static ByteBuffer glMapBuffer(int target, int access) {
        GlBuffer buffer = switch (target) {
            case 35051 -> pixelPackBufferBound;
            case 35052 -> pixelUnpackBufferBound;
            default -> throw new IllegalStateException("Unexpected value: " + target);
        };
        ByteBuffer mappedBuffer = buffer.data;
        mappedBuffer.position(0);
        return mappedBuffer;
    }

    public static boolean glUnmapBuffer(int i) {
        return true;
    }

    public static void glDeleteBuffers(IntBuffer intBuffer) {
        for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
            GlBuffer.glDeleteBuffers(intBuffer.get(i));
        }
    }

    public static void glDeleteBuffers(int id) {
        GlBuffer buffer = (GlBuffer)map.remove(id);
        if (buffer != null) {
            buffer.freeData();
        }
    }

    public static GlBuffer getPixelUnpackBufferBound() {
        return pixelUnpackBufferBound;
    }

    public static GlBuffer getPixelPackBufferBound() {
        return pixelPackBufferBound;
    }

    private static void checkTarget(int target) {
        if (target != 35052 && target != 35051) {
            throw new IllegalArgumentException("target %d not supported".formatted(target));
        }
    }

    public GlBuffer(int id) {
        this.id = id;
    }

    private void allocate(int size) {
        if (this.data != null) {
            this.freeData();
        }
        this.data = MemoryUtil.memAlloc((int)size);
    }

    private ByteBuffer getData() {
        return this.data;
    }

    private void freeData() {
        MemoryUtil.memFree((Buffer)this.data);
    }
}

