/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.config.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import net.vulkanmod.config.gui.GuiRenderer;
import net.vulkanmod.config.gui.widget.OptionWidget;
import net.vulkanmod.config.option.CyclingOption;
import net.vulkanmod.vulkan.util.ColorUtil;
import org.joml.Matrix4f;

public class CyclingOptionWidget
extends OptionWidget<CyclingOption<?>> {
    private Button leftButton;
    private Button rightButton;
    private boolean focused;

    public CyclingOptionWidget(CyclingOption<?> option, int x, int y, int width, int height, class_2561 name) {
        super(x, y, width, height, name);
        this.option = option;
        this.leftButton = new Button(this.controlX, 16, Button.Direction.LEFT);
        this.rightButton = new Button(this.controlX + this.controlWidth - 16, 16, Button.Direction.RIGHT);
    }

    @Override
    protected int getYImage(boolean hovered) {
        return 0;
    }

    @Override
    public void renderControls(double mouseX, double mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBars();
        this.leftButton.setStatus(((CyclingOption)this.option).index() > 0);
        this.rightButton.setStatus(((CyclingOption)this.option).index() < ((CyclingOption)this.option).getValues().length - 1);
        int color = this.active ? 0xFFFFFF : 0xA0A0A0;
        class_327 textRenderer = class_310.method_1551().field_1772;
        int x = this.controlX + this.controlWidth / 2;
        int y = this.y + (this.height - 9) / 2;
        GuiRenderer.drawCenteredString(textRenderer, this.getDisplayedValue(), x, y, color);
        this.leftButton.renderButton(GuiRenderer.guiGraphics.method_51448(), mouseX, mouseY);
        this.rightButton.renderButton(GuiRenderer.guiGraphics.method_51448(), mouseX, mouseY);
    }

    public void renderBars() {
        int count = ((CyclingOption)this.option).getValues().length;
        int current = ((CyclingOption)this.option).index();
        int margin = 30;
        int padding = 4;
        int barWidth = (this.controlWidth - 2 * margin - padding * count) / count;
        int color = ColorUtil.ARGB.pack(1.0f, 1.0f, 1.0f, 0.4f);
        int activeColor = ColorUtil.ARGB.pack(1.0f, 1.0f, 1.0f, 1.0f);
        if (barWidth <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            float x0 = this.controlX + margin + i * (barWidth + padding);
            float y0 = (float)(this.y + this.height) - 5.0f;
            int c = i == current ? activeColor : color;
            GuiRenderer.fill(x0, y0, x0 + (float)barWidth, y0 + 1.5f, c);
        }
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        if (this.leftButton.isHovered(mouseX, mouseY)) {
            ((CyclingOption)this.option).prevValue();
        } else if (this.rightButton.isHovered(mouseX, mouseY)) {
            ((CyclingOption)this.option).nextValue();
        }
    }

    @Override
    public void onRelease(double mouseX, double mouseY) {
    }

    @Override
    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
    }

    @Override
    public void method_25365(boolean bl) {
        this.focused = bl;
    }

    @Override
    public boolean method_25370() {
        return this.focused;
    }

    class Button {
        int x;
        int width;
        boolean active;
        Direction direction;

        Button(int x, int width, Direction direction) {
            this.x = x;
            this.width = width;
            this.active = true;
            this.direction = direction;
        }

        boolean isHovered(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)CyclingOptionWidget.this.y && mouseY <= (double)(CyclingOptionWidget.this.y + CyclingOptionWidget.this.height);
        }

        void setStatus(boolean status) {
            this.active = status;
        }

        void renderButton(class_4587 matrices, double mouseX, double mouseY) {
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27380, class_290.field_1592);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = this.isHovered(mouseX, mouseY) && this.active ? 5.0f : 4.5f;
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            RenderSystem.setShader((class_10156)class_10142.field_53875);
            RenderSystem.enableBlend();
            if (this.isHovered(mouseX, mouseY) && this.active) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (this.active) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            } else {
                RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)0.8f);
            }
            float h = f;
            float w = f - 1.0f;
            float yC = (float)CyclingOptionWidget.this.y + (float)CyclingOptionWidget.this.height * 0.5f;
            float xC = (float)this.x + (float)this.width * 0.5f;
            if (this.direction == Direction.LEFT) {
                bufferBuilder.method_22918(matrix4f, xC - w, yC, 0.0f);
                bufferBuilder.method_22918(matrix4f, xC + w, yC + h, 0.0f);
                bufferBuilder.method_22918(matrix4f, xC + w, yC - h, 0.0f);
            } else {
                bufferBuilder.method_22918(matrix4f, xC + w, yC, 0.0f);
                bufferBuilder.method_22918(matrix4f, xC - w, yC - h, 0.0f);
                bufferBuilder.method_22918(matrix4f, xC - w, yC + h, 0.0f);
            }
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader((class_10156)class_10142.field_53875);
        }

        static enum Direction {
            LEFT,
            RIGHT;

        }
    }
}

