/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.pass;

import net.minecraft.class_276;
import net.minecraft.class_310;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.framebuffer.Framebuffer;
import net.vulkanmod.vulkan.framebuffer.RenderPass;
import net.vulkanmod.vulkan.framebuffer.SwapChain;
import net.vulkanmod.vulkan.pass.MainPass;
import net.vulkanmod.vulkan.texture.VTextureSelector;
import net.vulkanmod.vulkan.texture.VulkanImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkRect2D;
import org.lwjgl.vulkan.VkViewport;

public class DefaultMainPass
implements MainPass {
    private class_276 mainTarget = class_310.method_1551().method_1522();
    private final Framebuffer mainFramebuffer = Renderer.getInstance().getSwapChain();
    private RenderPass mainRenderPass;
    private RenderPass auxRenderPass;

    public static DefaultMainPass create() {
        return new DefaultMainPass();
    }

    DefaultMainPass() {
        this.createRenderPasses();
    }

    private void createRenderPasses() {
        RenderPass.Builder builder = RenderPass.builder(this.mainFramebuffer);
        builder.getColorAttachmentInfo().setFinalLayout(2);
        builder.getColorAttachmentInfo().setOps(2, 0);
        builder.getDepthAttachmentInfo().setOps(2, 0);
        this.mainRenderPass = builder.build();
        builder = RenderPass.builder(this.mainFramebuffer);
        builder.getColorAttachmentInfo().setOps(0, 0);
        builder.getDepthAttachmentInfo().setOps(0, 0);
        builder.getColorAttachmentInfo().setFinalLayout(2);
        this.auxRenderPass = builder.build();
    }

    @Override
    public void begin(VkCommandBuffer commandBuffer, MemoryStack stack) {
        SwapChain framebuffer = Renderer.getInstance().getSwapChain();
        VulkanImage colorAttachment = framebuffer.getColorAttachment();
        colorAttachment.transitionImageLayout(stack, commandBuffer, 2);
        framebuffer.beginRenderPass(commandBuffer, this.mainRenderPass, stack);
        VkViewport.Buffer pViewport = framebuffer.viewport(stack);
        VK10.vkCmdSetViewport((VkCommandBuffer)commandBuffer, (int)0, (VkViewport.Buffer)pViewport);
        VkRect2D.Buffer pScissor = framebuffer.scissor(stack);
        VK10.vkCmdSetScissor((VkCommandBuffer)commandBuffer, (int)0, (VkRect2D.Buffer)pScissor);
    }

    @Override
    public void end(VkCommandBuffer commandBuffer) {
        Renderer.getInstance().endRenderPass(commandBuffer);
        try (MemoryStack stack = MemoryStack.stackPush();){
            SwapChain framebuffer = Renderer.getInstance().getSwapChain();
            framebuffer.getColorAttachment().transitionImageLayout(stack, commandBuffer, 1000001002);
        }
        int result = VK10.vkEndCommandBuffer((VkCommandBuffer)commandBuffer);
        if (result != 0) {
            throw new RuntimeException("Failed to record command buffer:" + result);
        }
    }

    @Override
    public void cleanUp() {
        this.mainRenderPass.cleanUp();
        this.auxRenderPass.cleanUp();
    }

    @Override
    public void rebindMainTarget() {
        SwapChain swapChain = Renderer.getInstance().getSwapChain();
        VkCommandBuffer commandBuffer = Renderer.getCommandBuffer();
        RenderPass boundRenderPass = Renderer.getInstance().getBoundRenderPass();
        if (boundRenderPass == this.mainRenderPass || boundRenderPass == this.auxRenderPass) {
            return;
        }
        Renderer.getInstance().endRenderPass(commandBuffer);
        try (MemoryStack stack = MemoryStack.stackPush();){
            swapChain.beginRenderPass(commandBuffer, this.auxRenderPass, stack);
        }
    }

    @Override
    public void bindAsTexture() {
        SwapChain swapChain = Renderer.getInstance().getSwapChain();
        VkCommandBuffer commandBuffer = Renderer.getCommandBuffer();
        RenderPass boundRenderPass = Renderer.getInstance().getBoundRenderPass();
        if (boundRenderPass == this.mainRenderPass || boundRenderPass == this.auxRenderPass) {
            Renderer.getInstance().endRenderPass(commandBuffer);
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            swapChain.getColorAttachment().transitionImageLayout(stack, commandBuffer, 5);
        }
        VTextureSelector.bindTexture(swapChain.getColorAttachment());
    }

    @Override
    public int getColorAttachmentGlId() {
        SwapChain swapChain = Renderer.getInstance().getSwapChain();
        return swapChain.getColorAttachmentGlId();
    }
}

