/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk.build.frapi.render;

import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.material.ShadeMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_324;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_811;
import net.vulkanmod.interfaces.color.BlockColorsExtended;
import net.vulkanmod.render.chunk.build.color.BlockColorRegistry;
import net.vulkanmod.render.chunk.build.frapi.helper.ColorHelper;
import net.vulkanmod.render.chunk.build.frapi.mesh.EncodingFormat;
import net.vulkanmod.render.chunk.build.frapi.mesh.MutableQuadViewImpl;
import net.vulkanmod.render.chunk.build.frapi.render.AbstractRenderContext;
import net.vulkanmod.render.chunk.build.light.LightPipeline;
import net.vulkanmod.render.chunk.build.light.data.QuadLightData;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockRenderContext
extends AbstractRenderContext {
    private static final Renderer RENDERER = RendererAccess.INSTANCE.getRenderer();
    protected static final RenderMaterial STANDARD_MATERIAL = RENDERER.materialFinder().shadeMode(ShadeMode.VANILLA).find();
    protected static final RenderMaterial NO_AO_MATERIAL = RENDERER.materialFinder().shadeMode(ShadeMode.VANILLA).ambientOcclusion(TriState.FALSE).find();
    protected final BlockColorRegistry blockColorRegistry;
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            AbstractBlockRenderContext.this.renderQuad(this);
        }
    };
    protected class_2680 blockState;
    protected class_2338 blockPos;
    protected class_2338.class_2339 tempPos = new class_2338.class_2339();
    protected class_1920 renderRegion;
    protected final Object2ByteLinkedOpenHashMap<class_2248.class_2249> occlusionCache = new Object2ByteLinkedOpenHashMap<class_2248.class_2249>(2048, 0.25f){

        protected void rehash(int i) {
        }
    };
    protected final QuadLightData quadLightData = new QuadLightData();
    protected LightPipeline smoothLightPipeline;
    protected LightPipeline flatLightPipeline;
    protected boolean useAO;
    protected boolean defaultAO;
    protected long seed;
    protected class_5819 random;
    public final Supplier<class_5819> randomSupplier = () -> {
        long seed = this.seed;
        this.random.method_43052(seed);
        return this.random;
    };
    protected boolean enableCulling = true;
    protected int cullCompletionFlags;
    protected int cullResultFlags;

    protected AbstractBlockRenderContext() {
        this.occlusionCache.defaultReturnValue((byte)127);
        class_324 blockColors = class_310.method_1551().method_1505();
        this.blockColorRegistry = BlockColorsExtended.from(blockColors).getColorResolverMap();
    }

    protected void setupLightPipelines(LightPipeline flatLightPipeline, LightPipeline smoothLightPipeline) {
        this.flatLightPipeline = flatLightPipeline;
        this.smoothLightPipeline = smoothLightPipeline;
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public class_811 itemTransformationMode() {
        throw new IllegalStateException("itemTransformationMode() can only be called on an item render context.");
    }

    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return null;
    }

    public void prepareForWorld(class_1920 blockView, boolean enableCulling) {
        this.renderRegion = blockView;
        this.enableCulling = enableCulling;
    }

    public void prepareForBlock(class_2680 blockState, class_2338 blockPos, boolean modelAo) {
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.useAO = class_310.method_1588();
        this.defaultAO = this.useAO && modelAo && blockState.method_26213() == 0;
        this.cullCompletionFlags = 0;
        this.cullResultFlags = 0;
    }

    public boolean isFaceCulled(@Nullable class_2350 face) {
        return !this.shouldRenderFace(face);
    }

    public boolean shouldRenderFace(class_2350 face) {
        if (face == null || !this.enableCulling) {
            return true;
        }
        int mask = 1 << face.method_10146();
        if ((this.cullCompletionFlags & mask) == 0) {
            this.cullCompletionFlags |= mask;
            if (this.faceNotOccluded(this.blockState, face)) {
                this.cullResultFlags |= mask;
                return true;
            }
            return false;
        }
        return (this.cullResultFlags & mask) != 0;
    }

    public boolean faceNotOccluded(class_2680 blockState, class_2350 face) {
        class_1920 blockGetter = this.renderRegion;
        class_2338.class_2339 adjPos = this.tempPos.method_25505((class_2382)this.blockPos, face);
        class_2680 adjBlockState = blockGetter.method_8320((class_2338)adjPos);
        if (blockState.method_26187(adjBlockState, face)) {
            return false;
        }
        if (adjBlockState.method_26225()) {
            class_265 shape = blockState.method_26173((class_1922)blockGetter, this.blockPos, face);
            if (shape.method_1110()) {
                return true;
            }
            class_265 adjShape = adjBlockState.method_26173((class_1922)blockGetter, (class_2338)adjPos, face.method_10153());
            if (adjShape.method_1110()) {
                return true;
            }
            if (shape == class_259.method_1077() && adjShape == class_259.method_1077()) {
                return false;
            }
            class_2248.class_2249 blockStatePairKey = new class_2248.class_2249(blockState, adjBlockState, face);
            byte b = this.occlusionCache.getAndMoveToFirst((Object)blockStatePairKey);
            if (b != 127) {
                return b != 0;
            }
            boolean bl = class_259.method_1074((class_265)shape, (class_265)adjShape, (class_247)class_247.field_16886);
            if (this.occlusionCache.size() == 2048) {
                this.occlusionCache.removeLastByte();
            }
            this.occlusionCache.putAndMoveToFirst((Object)blockStatePairKey, (byte)(bl ? 1 : 0));
            return bl;
        }
        return true;
    }

    private void renderQuad(MutableQuadViewImpl quad) {
        if (!this.transform((MutableQuadView)quad)) {
            return;
        }
        if (this.isFaceCulled(quad.cullFace())) {
            return;
        }
        this.endRenderQuad(quad);
    }

    protected void endRenderQuad(MutableQuadViewImpl quad) {
    }

    protected void colorizeQuad(MutableQuadViewImpl quad, int colorIndex) {
        if (colorIndex != -1) {
            int blockColor = this.getBlockColor(this.renderRegion, colorIndex);
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(blockColor, quad.color(i)));
            }
        }
    }

    private int getBlockColor(class_1920 region, int colorIndex) {
        class_322 blockColor = this.blockColorRegistry.getBlockColor(this.blockState.method_26204());
        int color = blockColor != null ? blockColor.getColor(this.blockState, region, this.blockPos, colorIndex) : -1;
        return 0xFF000000 | color;
    }

    protected void shadeQuad(MutableQuadViewImpl quad, LightPipeline lightPipeline, boolean emissive, boolean vanillaShade) {
        QuadLightData data = this.quadLightData;
        lightPipeline.calculate(quad, this.blockPos, data, quad.cullFace(), quad.lightFace(), quad.hasShade());
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyRGB(quad.color(i), data.br[i]));
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyRGB(quad.color(i), data.br[i]));
                quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), data.lm[i]));
            }
        }
    }

    public void emitBlockQuads(class_1087 model, @Nullable class_2680 state, Supplier<class_5819> randomSupplier, RenderContext context) {
        boolean noTransform;
        MutableQuadViewImpl quad = this.editorQuad;
        RenderMaterial defaultMaterial = model.method_4708() ? STANDARD_MATERIAL : NO_AO_MATERIAL;
        boolean bl = noTransform = !this.hasTransform();
        if (noTransform) {
            for (int i = 0; i <= 6; ++i) {
                class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
                if (context.isFaceCulled(cullFace)) continue;
                List quads = model.method_4707(state, cullFace, randomSupplier.get());
                int count = quads.size();
                for (int j = 0; j < count; ++j) {
                    class_777 q = (class_777)quads.get(j);
                    quad.fromVanilla(q, defaultMaterial, cullFace);
                    this.endRenderQuad(quad);
                }
            }
        } else {
            for (int i = 0; i <= 6; ++i) {
                class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
                List quads = model.method_4707(state, cullFace, randomSupplier.get());
                int count = quads.size();
                for (int j = 0; j < count; ++j) {
                    class_777 q = (class_777)quads.get(j);
                    quad.fromVanilla(q, defaultMaterial, cullFace);
                    this.renderQuad(quad);
                }
            }
        }
    }
}

