/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk.build.color;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Arrays;
import net.minecraft.class_1163;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_6539;
import net.vulkanmod.render.chunk.build.biome.BiomeData;
import net.vulkanmod.render.chunk.build.color.BoxBlur;

public class TintCache {
    private static final int SECTION_WIDTH = 16;
    private final Reference2ReferenceOpenHashMap<class_6539, Layer[]> layers = new Reference2ReferenceOpenHashMap();
    private BiomeData biomeData;
    private int blendRadius;
    private int totalWidth;
    private int secX;
    private int secY;
    private int secZ;
    private int minX;
    private int minZ;
    private int maxX;
    private int maxZ;
    private int dataSize;
    private int[] temp;

    public TintCache() {
        this.layers.put((Object)class_1163.field_5664, (Object)this.allocateLayers());
        this.layers.put((Object)class_1163.field_5665, (Object)this.allocateLayers());
        this.layers.put((Object)class_1163.field_5666, (Object)this.allocateLayers());
    }

    public void init(BiomeData biomeData, int blendRadius, int secX, int secY, int secZ) {
        this.biomeData = biomeData;
        this.blendRadius = (Integer)class_310.method_1551().field_1690.method_41805().method_41753();
        this.totalWidth = blendRadius * 2 + 16;
        this.secX = secX;
        this.secY = secY;
        this.secZ = secZ;
        this.minX = (secX << 4) - blendRadius;
        this.minZ = (secZ << 4) - blendRadius;
        this.maxX = (secX << 4) + 16 + blendRadius;
        this.maxZ = (secZ << 4) + 16 + blendRadius;
        int size = this.totalWidth * this.totalWidth;
        if (size != this.dataSize) {
            this.dataSize = size;
            ObjectIterator objectIterator = this.layers.values().iterator();
            while (objectIterator.hasNext()) {
                Layer[] layers;
                for (Layer layer : layers = (Layer[])objectIterator.next()) {
                    layer.allocate(size);
                }
            }
            this.temp = new int[size];
        } else {
            ObjectIterator objectIterator = this.layers.values().iterator();
            while (objectIterator.hasNext()) {
                Layer[] layers;
                for (Layer layer : layers = (Layer[])objectIterator.next()) {
                    layer.invalidate();
                }
            }
        }
    }

    public int getColor(class_2338 blockPos, class_6539 colorResolver) {
        int relY = blockPos.method_10264() & 0xF;
        if (!this.layers.containsKey((Object)colorResolver)) {
            this.addResolver(colorResolver);
        }
        Layer layer = ((Layer[])this.layers.get((Object)colorResolver))[relY];
        if (layer.invalidated) {
            this.calculateLayer(layer, colorResolver, relY);
        }
        int[] values = layer.getValues();
        int relX = blockPos.method_10263() & 0xF;
        int relZ = blockPos.method_10260() & 0xF;
        int idx = this.totalWidth * (relZ + this.blendRadius) + (relX + this.blendRadius);
        return values[idx];
    }

    private void addResolver(class_6539 colorResolver) {
        Layer[] layers1;
        for (Layer layer : layers1 = this.allocateLayers()) {
            layer.allocate(this.dataSize);
        }
        this.layers.put((Object)colorResolver, (Object)layers1);
    }

    private Layer[] allocateLayers() {
        Object[] layers = new Layer[16];
        Arrays.fill(layers, new Layer());
        return layers;
    }

    private void calculateLayer(Layer layer, class_6539 colorResolver, int y) {
        int absY = (this.secY << 4) + y;
        int[] values = layer.values;
        for (int absZ = this.minZ; absZ < this.maxZ; ++absZ) {
            for (int absX = this.minX; absX < this.maxX; ++absX) {
                class_1959 biome = this.biomeData.getBiome(absX, absY, absZ);
                int idx = absX - this.minX + (absZ - this.minZ) * this.totalWidth;
                values[idx] = colorResolver.getColor(biome, (double)absX, (double)absZ);
            }
        }
        if (this.blendRadius > 0) {
            this.applyBlur(values);
        }
        layer.invalidated = false;
    }

    private void applyBlur(int[] buffer) {
        int value = buffer[0];
        boolean needsBlur = false;
        for (int i = 1; i < buffer.length; ++i) {
            if (value == buffer[i]) continue;
            needsBlur = true;
            break;
        }
        if (needsBlur) {
            BoxBlur.blur(buffer, this.temp, 16, this.blendRadius);
        }
    }

    static class Layer {
        private boolean invalidated = true;
        private int[] values;

        Layer() {
        }

        void allocate(int size) {
            this.values = new int[size];
            this.invalidate();
        }

        void invalidate() {
            this.invalidated = true;
        }

        public int[] getValues() {
            return this.values;
        }
    }
}

