/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.mixin.texture.mip;

import net.minecraft.class_1011;
import net.minecraft.class_4725;
import net.vulkanmod.mixin.texture.image.NativeImageAccessor;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_4725.class})
public abstract class MipmapGeneratorM {
    private static final int ALPHA_CUTOFF = 50;

    @Shadow
    private static float method_24099(int i) {
        return 0.0f;
    }

    @Overwrite
    public static class_1011[] method_24102(class_1011[] nativeImages, int i) {
        class_1011 nativeImage;
        if (i + 1 <= nativeImages.length) {
            return nativeImages;
        }
        class_1011[] nativeImages2 = new class_1011[i + 1];
        nativeImages2[0] = nativeImages[0];
        long srcPtr = ((NativeImageAccessor)nativeImages2[0]).getPixels();
        boolean bl = MipmapGeneratorM.hasTransparentPixel(srcPtr, nativeImages2[0].method_4307(), nativeImages2[0].method_4323());
        if (bl) {
            int avg = MipmapGeneratorM.calculateAverage(nativeImages2[0]);
            avg &= 0xFFFFFF;
            nativeImage = nativeImages2[0];
            int width = nativeImage.method_4307();
            int height = nativeImage.method_4323();
            for (int m = 0; m < width; ++m) {
                for (int n = 0; n < height; ++n) {
                    int p0 = MemoryUtil.memGetInt((long)(srcPtr + ((long)m + (long)n * (long)width) * 4L));
                    boolean b0 = (p0 >> 24 & 0xFF) >= 50;
                    int outColor = p0 = b0 ? p0 : avg | p0 & 0xFF000000;
                    MemoryUtil.memPutInt((long)(srcPtr + ((long)m + (long)n * (long)width) * 4L), (int)outColor);
                }
            }
        }
        for (int j = 1; j <= i; ++j) {
            if (j < nativeImages.length) {
                nativeImages2[j] = nativeImages[j];
                continue;
            }
            nativeImage = nativeImages2[j - 1];
            class_1011 nativeImage2 = new class_1011(nativeImage.method_4307() >> 1, nativeImage.method_4323() >> 1, false);
            int width = nativeImage2.method_4307();
            int height = nativeImage2.method_4323();
            srcPtr = ((NativeImageAccessor)nativeImage).getPixels();
            long dstPtr = ((NativeImageAccessor)nativeImage2).getPixels();
            int width2 = width * 2;
            for (int m = 0; m < width; ++m) {
                for (int n = 0; n < height; ++n) {
                    int p0 = MemoryUtil.memGetInt((long)(srcPtr + (long)(m * 2 + 0 + (n * 2 + 0) * width2) * 4L));
                    int p1 = MemoryUtil.memGetInt((long)(srcPtr + (long)(m * 2 + 1 + (n * 2 + 0) * width2) * 4L));
                    int p2 = MemoryUtil.memGetInt((long)(srcPtr + (long)(m * 2 + 0 + (n * 2 + 1) * width2) * 4L));
                    int p3 = MemoryUtil.memGetInt((long)(srcPtr + (long)(m * 2 + 1 + (n * 2 + 1) * width2) * 4L));
                    int outColor = MipmapGeneratorM.blend(p0, p1, p2, p3);
                    MemoryUtil.memPutInt((long)(dstPtr + ((long)m + (long)n * (long)width) * 4L), (int)outColor);
                }
            }
            nativeImages2[j] = nativeImage2;
        }
        return nativeImages2;
    }

    private static boolean hasTransparentPixel(long ptr, int width, int height) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (MipmapGeneratorM.getPixelA(MemoryUtil.memGetInt((long)(ptr + (long)(i + j * width) * 4L))) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private static int blend(int p0, int p1, int p2, int p3) {
        int a = MipmapGeneratorM.gammaBlend(p0, p1, p2, p3, 24);
        int b = MipmapGeneratorM.gammaBlend(p0, p1, p2, p3, 16);
        int g = MipmapGeneratorM.gammaBlend(p0, p1, p2, p3, 8);
        int r = MipmapGeneratorM.gammaBlend(p0, p1, p2, p3, 0);
        return a << 24 | b << 16 | g << 8 | r;
    }

    private static int getMax(int i0, int i1, int i2, int i3) {
        return Math.max(Math.max(Math.max(i0, i1), i2), i3);
    }

    private static int gammaBlend(int i, int j, int k, int l, int m) {
        float f = MipmapGeneratorM.method_24099(i >> m);
        float g = MipmapGeneratorM.method_24099(j >> m);
        float h = MipmapGeneratorM.method_24099(k >> m);
        float n = MipmapGeneratorM.method_24099(l >> m);
        float o = (float)((double)((float)Math.pow((double)(f + g + h + n) * 0.25, 0.45454545454545453)));
        return (int)((double)o * 255.0);
    }

    private static int getPixelA(int rgba) {
        return rgba >> 24;
    }

    private static int calculateAverage(class_1011 nativeImage) {
        int width = nativeImage.method_4307();
        int height = nativeImage.method_4323();
        int[] values = new int[width * height];
        int count = 0;
        long srcPtr = ((NativeImageAccessor)nativeImage).getPixels();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int value = MemoryUtil.memGetInt((long)(srcPtr + ((long)i + (long)j * (long)width) * 4L));
                if ((value >> 24 & 0xFF) <= 0) continue;
                values[count] = value;
                ++count;
            }
        }
        int sumR = 0;
        int sumG = 0;
        int sumB = 0;
        for (int i = 0; i < count; ++i) {
            sumR += values[i] & 0xFF;
            sumG += values[i] >> 8 & 0xFF;
            sumB += values[i] >> 16 & 0xFF;
        }
        if (count == 0) {
            return 0;
        }
        return (sumR /= count) & 0xFF | ((sumG /= count) & 0xFF) << 8 | ((sumB /= count) & 0xFF) << 16 | 0xFF000000;
    }
}

