/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.mixin.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1011;
import net.vulkanmod.gl.GlTexture;
import net.vulkanmod.vulkan.texture.VTextureSelector;
import net.vulkanmod.vulkan.texture.VulkanImage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={TextureUtil.class})
public class MTextureUtil {
    @Overwrite(remap=false)
    public static int generateTextureId() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GlTexture.genTextureId();
    }

    @Overwrite(remap=false)
    public static void prepareImage(class_1011.class_1013 internalGlFormat, int id, int mipLevels, int width, int height) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlTexture.bindTexture(id);
        GlTexture glTexture = GlTexture.getBoundTexture();
        VulkanImage image = glTexture.getVulkanImage();
        if (mipLevels > 0) {
            GlStateManager._texParameter((int)3553, (int)33085, (int)mipLevels);
            GlStateManager._texParameter((int)3553, (int)33082, (int)0);
            GlStateManager._texParameter((int)3553, (int)33083, (int)mipLevels);
            GlStateManager._texParameter((int)3553, (int)34049, (float)0.0f);
        }
        if (image == null || image.mipLevels != mipLevels || image.width != width || image.height != height) {
            if (image != null) {
                image.free();
            }
            image = new VulkanImage.Builder(width, height).setMipLevels(mipLevels + 1).setFormat(internalGlFormat).setLinearFiltering(false).setClamp(false).createVulkanImage();
            glTexture.setVulkanImage(image);
            VTextureSelector.bindTexture(image);
        }
    }
}

