/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.mixin.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.class_8251;
import net.vulkanmod.gl.GlTexture;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.VRenderSystem;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RenderSystem.class})
public abstract class RenderSystemMixin {
    @Shadow
    private static Matrix4f projectionMatrix;
    @Shadow
    private static Matrix4f savedProjectionMatrix;
    @Shadow
    @Final
    private static Matrix4fStack modelViewStack;
    @Shadow
    private static Matrix4f modelViewMatrix;
    @Shadow
    private static Matrix4f textureMatrix;
    @Shadow
    @Final
    private static float[] shaderColor;
    @Shadow
    @Final
    private static Vector3f[] shaderLightDirections;
    @Shadow
    @Final
    private static float[] shaderFogColor;
    @Shadow
    @Nullable
    private static Thread renderThread;
    @Shadow
    public static class_8251 vertexSorting;
    @Shadow
    private static class_8251 savedVertexSorting;

    @Shadow
    public static void assertOnRenderThread() {
    }

    @Overwrite(remap=false)
    public static void initRenderer(int debugVerbosity, boolean debugSync) {
        VRenderSystem.initRenderer();
        renderThread.setPriority(7);
    }

    @Overwrite(remap=false)
    public static void setupDefaultState(int x, int y, int width, int height) {
    }

    @Overwrite(remap=false)
    public static void enableColorLogicOp() {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.enableColorLogicOp();
    }

    @Overwrite(remap=false)
    public static void disableColorLogicOp() {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.disableColorLogicOp();
    }

    @Overwrite
    public static void logicOp(GlStateManager.class_1030 op) {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.logicOp(op);
    }

    @Overwrite(remap=false)
    public static void activeTexture(int texture) {
        GlTexture.activeTexture(texture);
    }

    @Overwrite(remap=false)
    public static void glGenBuffers(Consumer<Integer> consumer) {
    }

    @Overwrite(remap=false)
    public static void glGenVertexArrays(Consumer<Integer> consumer) {
    }

    @Overwrite(remap=false)
    public static int maxSupportedTextureSize() {
        return VRenderSystem.maxSupportedTextureSize();
    }

    @Overwrite(remap=false)
    public static void clear(int mask, boolean getError) {
        VRenderSystem.clear(mask);
    }

    @Overwrite(remap=false)
    public static void clearColor(float r, float g, float b, float a) {
        VRenderSystem.setClearColor(r, g, b, a);
    }

    @Overwrite(remap=false)
    public static void clearDepth(double d) {
        VRenderSystem.clearDepth(d);
    }

    @Overwrite(remap=false)
    public static void enableScissor(int x, int y, int width, int height) {
        Renderer.setScissor(x, y, width, height);
    }

    @Overwrite(remap=false)
    public static void disableScissor() {
        Renderer.resetScissor();
    }

    @Overwrite(remap=false)
    public static void disableDepthTest() {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.disableDepthTest();
    }

    @Overwrite(remap=false)
    public static void enableDepthTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        VRenderSystem.enableDepthTest();
    }

    @Overwrite(remap=false)
    public static void depthFunc(int i) {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.depthFunc(i);
    }

    @Overwrite(remap=false)
    public static void depthMask(boolean b) {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.depthMask(b);
    }

    @Overwrite(remap=false)
    public static void colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        VRenderSystem.colorMask(red, green, blue, alpha);
    }

    @Overwrite(remap=false)
    public static void blendEquation(int i) {
        RenderSystemMixin.assertOnRenderThread();
    }

    @Overwrite(remap=false)
    public static void enableBlend() {
        VRenderSystem.enableBlend();
    }

    @Overwrite(remap=false)
    public static void disableBlend() {
        VRenderSystem.disableBlend();
    }

    @Overwrite(remap=false)
    public static void blendFunc(GlStateManager.class_4535 sourceFactor, GlStateManager.class_4534 destFactor) {
        VRenderSystem.blendFunc(sourceFactor, destFactor);
    }

    @Overwrite(remap=false)
    public static void blendFunc(int srcFactor, int dstFactor) {
        VRenderSystem.blendFunc(srcFactor, dstFactor);
    }

    @Overwrite(remap=false)
    public static void blendFuncSeparate(GlStateManager.class_4535 p_69417_, GlStateManager.class_4534 p_69418_, GlStateManager.class_4535 p_69419_, GlStateManager.class_4534 p_69420_) {
        VRenderSystem.blendFuncSeparate(p_69417_, p_69418_, p_69419_, p_69420_);
    }

    @Overwrite(remap=false)
    public static void blendFuncSeparate(int srcFactorRGB, int dstFactorRGB, int srcFactorAlpha, int dstFactorAlpha) {
        VRenderSystem.blendFuncSeparate(srcFactorRGB, dstFactorRGB, srcFactorAlpha, dstFactorAlpha);
    }

    @Overwrite(remap=false)
    public static void enableCull() {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.enableCull();
    }

    @Overwrite(remap=false)
    public static void disableCull() {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.disableCull();
    }

    @Overwrite(remap=false)
    public static void polygonMode(int i, int j) {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.setPolygonModeGL(i);
    }

    @Overwrite(remap=false)
    public static void enablePolygonOffset() {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.enablePolygonOffset();
    }

    @Overwrite(remap=false)
    public static void disablePolygonOffset() {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.disablePolygonOffset();
    }

    @Overwrite(remap=false)
    public static void polygonOffset(float p_69864_, float p_69865_) {
        RenderSystemMixin.assertOnRenderThread();
        VRenderSystem.polygonOffset(p_69864_, p_69865_);
    }

    @Overwrite(remap=false)
    public static void setShaderLights(Vector3f dir0, Vector3f dir1) {
        RenderSystemMixin.shaderLightDirections[0] = dir0;
        RenderSystemMixin.shaderLightDirections[1] = dir1;
        VRenderSystem.lightDirection0.buffer.putFloat(0, dir0.x());
        VRenderSystem.lightDirection0.buffer.putFloat(4, dir0.y());
        VRenderSystem.lightDirection0.buffer.putFloat(8, dir0.z());
        VRenderSystem.lightDirection1.buffer.putFloat(0, dir1.x());
        VRenderSystem.lightDirection1.buffer.putFloat(4, dir1.y());
        VRenderSystem.lightDirection1.buffer.putFloat(8, dir1.z());
    }

    @Overwrite(remap=false)
    private static void _setShaderColor(float r, float g, float b, float a) {
        RenderSystemMixin.shaderColor[0] = r;
        RenderSystemMixin.shaderColor[1] = g;
        RenderSystemMixin.shaderColor[2] = b;
        RenderSystemMixin.shaderColor[3] = a;
        VRenderSystem.setShaderColor(r, g, b, a);
    }

    @Overwrite(remap=false)
    public static void setShaderFogColor(float f, float g, float h, float i) {
        RenderSystemMixin.shaderFogColor[0] = f;
        RenderSystemMixin.shaderFogColor[1] = g;
        RenderSystemMixin.shaderFogColor[2] = h;
        RenderSystemMixin.shaderFogColor[3] = i;
        VRenderSystem.setShaderFogColor(f, g, h, i);
    }

    @Overwrite(remap=false)
    public static void setProjectionMatrix(Matrix4f projectionMatrix, class_8251 vertexSorting) {
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)projectionMatrix);
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                projectionMatrix = matrix4f;
                RenderSystem.vertexSorting = vertexSorting;
                VRenderSystem.applyProjectionMatrix(matrix4f);
                VRenderSystem.calculateMVP();
            });
        } else {
            RenderSystemMixin.projectionMatrix = matrix4f;
            RenderSystem.vertexSorting = vertexSorting;
            VRenderSystem.applyProjectionMatrix(matrix4f);
            VRenderSystem.calculateMVP();
        }
    }

    @Overwrite(remap=false)
    public static void setTextureMatrix(Matrix4f matrix4f) {
        Matrix4f matrix4f2 = new Matrix4f((Matrix4fc)matrix4f);
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                textureMatrix = matrix4f2;
                VRenderSystem.setTextureMatrix(matrix4f);
            });
        } else {
            textureMatrix = matrix4f2;
            VRenderSystem.setTextureMatrix(matrix4f);
        }
    }

    @Overwrite(remap=false)
    public static void resetTextureMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> textureMatrix.identity());
        } else {
            textureMatrix.identity();
            VRenderSystem.setTextureMatrix(textureMatrix);
        }
    }

    @Overwrite(remap=false)
    public static void applyModelViewMatrix() {
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)modelViewStack);
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                modelViewMatrix = matrix4f;
                VRenderSystem.applyModelViewMatrix(matrix4f);
                VRenderSystem.calculateMVP();
            });
        } else {
            modelViewMatrix = matrix4f;
            VRenderSystem.applyModelViewMatrix(matrix4f);
            VRenderSystem.calculateMVP();
        }
    }

    @Overwrite(remap=false)
    private static void _restoreProjectionMatrix() {
        projectionMatrix = savedProjectionMatrix;
        vertexSorting = savedVertexSorting;
        VRenderSystem.applyProjectionMatrix(projectionMatrix);
        VRenderSystem.calculateMVP();
    }

    @Overwrite(remap=false)
    public static void texParameter(int target, int pname, int param) {
        GlTexture.texParameteri(target, pname, param);
    }
}

