/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.config.video;

import java.util.ArrayList;
import net.vulkanmod.Initializer;
import net.vulkanmod.config.video.VideoModeSet;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;

public abstract class VideoModeManager {
    private static VideoModeSet.VideoMode osVideoMode;
    private static VideoModeSet[] videoModeSets;
    public static VideoModeSet.VideoMode selectedVideoMode;

    public static void init() {
        long monitor = GLFW.glfwGetPrimaryMonitor();
        osVideoMode = VideoModeManager.getCurrentVideoMode(monitor);
        videoModeSets = VideoModeManager.populateVideoResolutions(GLFW.glfwGetPrimaryMonitor());
    }

    public static void applySelectedVideoMode() {
        Initializer.CONFIG.videoMode = selectedVideoMode;
    }

    public static VideoModeSet[] getVideoResolutions() {
        return videoModeSets;
    }

    public static VideoModeSet getFirstAvailable() {
        if (videoModeSets != null) {
            return videoModeSets[videoModeSets.length - 1];
        }
        return VideoModeSet.getDummy();
    }

    public static VideoModeSet.VideoMode getOsVideoMode() {
        return osVideoMode;
    }

    public static VideoModeSet.VideoMode getCurrentVideoMode(long monitor) {
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)monitor);
        if (vidMode == null) {
            throw new NullPointerException("Unable to get current video mode");
        }
        return new VideoModeSet.VideoMode(vidMode.width(), vidMode.height(), vidMode.redBits(), vidMode.refreshRate());
    }

    public static VideoModeSet[] populateVideoResolutions(long monitor) {
        GLFWVidMode.Buffer buffer = GLFW.glfwGetVideoModes((long)monitor);
        ArrayList<VideoModeSet> videoModeSets = new ArrayList<VideoModeSet>();
        int currWidth = 0;
        int currHeight = 0;
        int currBitDepth = 0;
        VideoModeSet videoModeSet = null;
        for (int i = 0; i < buffer.limit(); ++i) {
            buffer.position(i);
            int bitDepth = buffer.redBits();
            if (buffer.redBits() < 8 || buffer.greenBits() != bitDepth || buffer.blueBits() != bitDepth) continue;
            int width = buffer.width();
            int height = buffer.height();
            int refreshRate = buffer.refreshRate();
            if (currWidth != width || currHeight != height || currBitDepth != bitDepth) {
                currWidth = width;
                currHeight = height;
                currBitDepth = bitDepth;
                videoModeSet = new VideoModeSet(currWidth, currHeight, currBitDepth);
                videoModeSets.add(videoModeSet);
            }
            videoModeSet.addRefreshRate(refreshRate);
        }
        VideoModeSet[] arr = new VideoModeSet[videoModeSets.size()];
        videoModeSets.toArray(arr);
        return arr;
    }

    public static VideoModeSet getFromVideoMode(VideoModeSet.VideoMode videoMode) {
        for (VideoModeSet set : videoModeSets) {
            if (set.width != videoMode.width || set.height != videoMode.height) continue;
            return set;
        }
        return null;
    }
}

