/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.config.option;

import net.vulkanmod.config.gui.OptionBlock;
import net.vulkanmod.config.gui.VOptionList;
import net.vulkanmod.config.option.Option;

public class OptionPage {
    public final String name;
    OptionBlock[] optionBlocks;
    private VOptionList optionList;

    public OptionPage(String name, OptionBlock[] optionBlocks) {
        this.name = name;
        this.optionBlocks = optionBlocks;
    }

    public void createList(int x, int y, int width, int height, int itemHeight) {
        this.optionList = new VOptionList(x, y, width, height, itemHeight);
        this.optionList.addAll(this.optionBlocks);
    }

    public VOptionList getOptionList() {
        return this.optionList;
    }

    public boolean optionChanged() {
        boolean changed = false;
        for (OptionBlock block : this.optionBlocks) {
            for (Option<?> option : block.options()) {
                if (!option.isChanged()) continue;
                changed = true;
            }
        }
        return changed;
    }

    public void applyOptionChanges() {
        for (OptionBlock block : this.optionBlocks) {
            for (Option<?> option : block.options()) {
                if (!option.isChanged()) continue;
                option.apply();
            }
        }
    }
}

